% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unres.R
\name{predict.unres}
\alias{predict.unres}
\title{Extract Model Predictions Values}
\usage{
\method{predict}{unres}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class \code{unrestricted}.}

\item{newdata}{An optional data frame in which to look for variables with which to predict.
If omitted, the fitted values are used.}

\item{...}{Other arguments.}
}
\value{
A vector of predictions.
}
\description{
Predicted values based on object \code{unrestrcited}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
model <- unres(X, y)
predict(model, X)
}
\seealso{
\code{\link{predict.res}},
\code{\link{predict.pt}},
\code{\link{predict.ipt}},
\code{\link{predict.st}},
\code{\link{predict.pst}}.
}
