% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res.R
\name{predict.res}
\alias{predict.res}
\title{Extract Model Predictions Values}
\usage{
\method{predict}{res}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class \code{restricted}.}

\item{newdata}{An optional data frame in which to look for variables with which to predict.
If omitted, the fitted values are used.}

\item{...}{Other arguments.}
}
\value{
A vector of predictions.
}
\description{
Predicted values based on object \code{restrcited}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- res(X, y, H, h)
predict(model, X)
}
\seealso{
\code{\link{predict.unres}},
\code{\link{predict.pt}},
\code{\link{predict.ipt}},
\code{\link{predict.st}},
\code{\link{predict.pst}}.
}
