% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st.R
\name{fitted.st}
\alias{fitted.st}
\title{Extract Model Fitted Values}
\usage{
\method{fitted}{st}(object, ...)
}
\arguments{
\item{object}{An object of class \code{stein}.}

\item{...}{Other arguments.}
}
\value{
A vector of fitted values.
}
\description{
Fitted values based on object \code{stein}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nr = 3, nc = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- stein(X, y, H, h)
fitted(model)
}
\seealso{
\code{\link{fitted.unres}},
\code{\link{fitted.res}},
\code{\link{fitted.pt}},
\code{\link{fitted.ipt}},
\code{\link{fitted.pst}}
}
