% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt.R
\name{fitted.pt}
\alias{fitted.pt}
\title{Extract Model Fitted Values}
\usage{
\method{fitted}{pt}(object, ...)
}
\arguments{
\item{object}{An object of class \code{preliminaryTest}.}

\item{...}{Other arguments.}
}
\value{
A vector of fitted values.
}
\description{
Fitted values based on object \code{preliminaryTest}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- pt(X, y, H, h, alpha = 0.05)
fitted(model)

}
\seealso{
\code{\link{fitted.unres}},
\code{\link{fitted.res}},
\code{\link{fitted.ipt}},
\code{\link{fitted.st}},
\code{\link{fitted.pst}}
}
