% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipt.R
\name{fitted.ipt}
\alias{fitted.ipt}
\title{Extract Model Fitted Values}
\usage{
\method{fitted}{ipt}(object, ...)
}
\arguments{
\item{object}{An object of class \code{improvedpreliminaryTest}.}

\item{...}{Other arguments.}
}
\value{
A vector of fitted values.
}
\description{
Fitted values based on object \code{improvedpreliminaryTest}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- ipt(X, y, H, h, alpha = 0.05)
fitted(model)

}
\seealso{
\code{\link{fitted.unres}},
\code{\link{fitted.res}},
\code{\link{fitted.pt}},
\code{\link{fitted.st}},
\code{\link{fitted.pst}}.
}
