% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unres.R
\name{coefficients.unres}
\alias{coefficients.unres}
\alias{coef.unres}
\title{Extract Model Coefficients}
\usage{
\method{coefficients}{unres}(object, ...)

\method{coef}{unres}(object, ...)
}
\arguments{
\item{object}{An object of class \code{unrestricted}.}

\item{...}{Other arguments.}
}
\value{
A vector of coefficients.
}
\description{
Coefficients extracted from the model object \code{unrestrcited}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
model <- unres(X, y)
coefficients(model)
coef(model)
}
\seealso{
\code{\link{coefficients.res}},
\code{\link{coefficients.pt}},
\code{\link{coefficients.ipt}},
\code{\link{coefficients.st}},
\code{\link{coefficients.pst}},
\code{\link{coef.res}},
\code{\link{coef.pt}},
\code{\link{coef.ipt}}
\code{\link{coef.st}},
\code{\link{coef.pst}}.
}
