% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res.R
\name{coefficients.res}
\alias{coefficients.res}
\alias{coef.res}
\title{Extract Model Coefficients}
\usage{
\method{coefficients}{res}(object, ...)

\method{coef}{res}(object, ...)
}
\arguments{
\item{object}{An object of class \code{restricted}.}

\item{...}{Other arguments.}
}
\value{
A vector of coefficients.
}
\description{
Coefficients extracted from the model object \code{restrcited}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- res(X, y, H, h)
coefficients(model)
coef(model)
}
\seealso{
\code{\link{coefficients.unres}},
\code{\link{coefficients.pt}},
\code{\link{coefficients.ipt}},
\code{\link{coefficients.st}},
\code{\link{coefficients.pst}},
\code{\link{coef.unres}},
\code{\link{coef.pt}},
\code{\link{coef.ipt}}
\code{\link{coef.st}},
\code{\link{coef.pst}}.
}
