% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iptReg.R
\name{coefficients.improvedpreliminaryTest}
\alias{coefficients.improvedpreliminaryTest}
\alias{coef.improvedpreliminaryTest}
\title{Extract Model Coefficients}
\usage{
\method{coefficients}{improvedpreliminaryTest}(object, ...)

\method{coef}{improvedpreliminaryTest}(object, ...)
}
\arguments{
\item{object}{An object of class \code{improvedpreliminaryTest}.}

\item{...}{Other arguments.}
}
\value{
A vector of coefficients.
}
\description{
Coefficients extracted from the model object \code{improvedpreliminaryTest}
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- iptReg(X, y, H, h, alpha = 0.05)
coefficients(model)
coef(model)
}
\seealso{
\code{\link{coefficients.unrestricted}},
\code{\link{coefficients.restricted}},
\code{\link{coefficients.preliminaryTest}},
\code{\link{coefficients.stein}},
\code{\link{coefficients.positivestein}},
\code{\link{coef.unrestricted}},
\code{\link{coef.restricted}},
\code{\link{coef.positivestein}},
\code{\link{coef.stein}},
\code{\link{coef.positivestein}}.
}
