% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbReadTableArrow.R
\name{dbReadTableArrow}
\alias{dbReadTableArrow}
\title{Read database tables as Arrow objects}
\usage{
dbReadTableArrow(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[=Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[=SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbReadTableArrow()} returns an Arrow object that contains the complete data
from the remote table, effectively the result of calling \code{\link[DBI:dbGetQueryArrow]{DBI::dbGetQueryArrow()}} with
\verb{SELECT * FROM <name>}.

An empty table is returned as an Arrow object with zero rows.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Reads a database table as an Arrow object.
Use \code{\link[=dbReadTable]{dbReadTable()}} instead to obtain a data frame.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbReadTableArrow")}
}
\details{
This function returns an Arrow object.
Convert it to a data frame with \code{\link[=as.data.frame]{as.data.frame()}} or
use \code{\link[=dbReadTable]{dbReadTable()}} to obtain a data frame.
}
\section{Failure modes}{


An error is raised if the table does not exist.


An error is raised when calling this method for a closed
or invalid connection.
An error is raised
if \code{name} cannot be processed with \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}} or
if this results in a non-scalar.

}

\section{Specification}{


The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbReadTableArrow()} will do the
quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}}: no more quoting is done
}

}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE) && requireNamespace("nanoarrow", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Read data as Arrow table
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars[1:10, ])
dbReadTableArrow(con, "mtcars")

dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbAppendTableArrow}()},
\code{\link{dbCreateTable}()},
\code{\link{dbCreateTableArrow}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbGetQueryArrow}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbReadTable}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendQueryArrow}()},
\code{\link{dbSendStatement}()},
\code{\link{dbUnquoteIdentifier}()},
\code{\link{dbWriteTable}()},
\code{\link{dbWriteTableArrow}()}
}
\concept{DBIConnection generics}
