% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsize.R
\name{nsize}
\alias{nsize}
\title{Required Sample Size}
\usage{
nsize(b, sigma = NULL, p = 0.5, conf.level = 0.95, type = "mu")
}
\arguments{
\item{b}{the desired bound.}

\item{sigma}{population standard deviation. Not required if using type
\code{"pi"}.}

\item{p}{estimate for the population proportion of successes. Not required
if using type \code{"mu"}.}

\item{conf.level}{confidence level for the problem, restricted to lie
between zero and one.}

\item{type}{character string, one of \code{"mu"} or \code{"pi"}, or just the
initial letter of each, indicating the appropriate parameter. Default value
is \code{"mu"}.}
}
\value{
Returns required sample size.
}
\description{
Function to determine required sample size to be within a given margin of
error.
}
\details{
Answer is based on a normal approximation when using type \code{"pi"}.
}
\examples{

nsize(b=.03, p=708/1200, conf.level=.90, type="pi")
    # Returns the required sample size (n) to estimate the population 
    # proportion of successes with a 0.9 confidence interval 
    # so that the margin of error is no more than 0.03 when the
    # estimate of the population propotion of successes is 708/1200.
    # This is problem 5.38 on page 257 of Kitchen's BSDA.
    
nsize(b=.15, sigma=.31, conf.level=.90, type="mu")
    # Returns the required sample size (n) to estimate the population 
    # mean with a 0.9 confidence interval so that the margin 
    # of error is no more than 0.15.  This is Example 5.17 on page
    # 261 of Kitchen's BSDA.

}
\author{
Alan T. Arnholt
}
\keyword{univar}
