char shaderpipeline_vert[] = "#ifdef GL_ES\n"
                             "    precision highp float;\n"
                             "    precision highp int;\n"
                             "#endif\n"
                             "\n"
                             "#pragma import_modes ( GL_LIGHTING, GL_LIGHT0)\n"
                             "#pragma import_texture_modes ( GL_TEXTURE_GEN_S, GL_TEXTURE_GEN_T, GL_TEXTURE_GEN_R, GL_TEXTURE_GEN_Q)\n"
                             "#pragma import_defines ( GL_MAX_TEXTURE_UNITS )\n"
                             "#pragma import_defines ( TEXTURE_VERT_DECLARE0, TEXTURE_VERT_BODY0, TEXTURE_GEN_FUNCTION0 )\n"
                             "#pragma import_defines ( TEXTURE_VERT_DECLARE1, TEXTURE_VERT_BODY1, TEXTURE_GEN_FUNCTION1 )\n"
                             "#pragma import_defines ( TEXTURE_VERT_DECLARE2, TEXTURE_VERT_BODY2, TEXTURE_GEN_FUNCTION2 )\n"
                             "#pragma import_defines ( TEXTURE_VERT_DECLARE3, TEXTURE_VERT_BODY3, TEXTURE_GEN_FUNCTION3 )\n"
                             "\n"
                             "#if GL_MAX_TEXTURE_UNITS>0\n"
                             "\n"
                             "uniform bool GL_ACTIVE_TEXTURE[GL_MAX_TEXTURE_UNITS];\n"
                             "\n"
                             "uniform vec4 osg_ObjectPlaneR[GL_MAX_TEXTURE_UNITS];\n"
                             "uniform vec4 osg_ObjectPlaneS[GL_MAX_TEXTURE_UNITS];\n"
                             "uniform vec4 osg_ObjectPlaneT[GL_MAX_TEXTURE_UNITS];\n"
                             "uniform vec4 osg_ObjectPlaneQ[GL_MAX_TEXTURE_UNITS];\n"
                             "\n"
                             "uniform vec4 osg_EyePlaneR[GL_MAX_TEXTURE_UNITS];\n"
                             "uniform vec4 osg_EyePlaneS[GL_MAX_TEXTURE_UNITS];\n"
                             "uniform vec4 osg_EyePlaneT[GL_MAX_TEXTURE_UNITS];\n"
                             "uniform vec4 osg_EyePlaneQ[GL_MAX_TEXTURE_UNITS];\n"
                             "\n"
                             "\n"
                             "vec4 texgen_EYE_LINEAR(vec4 texcoord, int unit, bool s, bool t, bool r, bool q)\n"
                             "{\n"
                             "    vec4 vertex_eye = gl_ModelViewMatrix * gl_Vertex;\n"
                             "    if (s) texcoord.s = dot(vertex_eye , gl_EyePlaneS[unit]);\n"
                             "    if (t) texcoord.t = dot(vertex_eye , gl_EyePlaneT[unit]);\n"
                             "    if (r) texcoord.r = dot(vertex_eye , gl_EyePlaneR[unit]);\n"
                             "    if (q) texcoord.q = dot(vertex_eye , gl_EyePlaneQ[unit]);\n"
                             "    return texcoord;\n"
                             "}\n"
                             "\n"
                             "vec4 texgen_OBJECT_LINEAR(vec4 texcoord, int unit, bool s, bool t, bool r, bool q)\n"
                             "{\n"
                             "    vec4 vertex_eye = gl_ModelViewMatrix * gl_Vertex;\n"
                             "    if (s) texcoord.s = dot(gl_Vertex , gl_ObjectPlaneS[unit]);\n"
                             "    if (t) texcoord.t = dot(gl_Vertex , gl_ObjectPlaneT[unit]);\n"
                             "    if (r) texcoord.r = dot(gl_Vertex , gl_ObjectPlaneR[unit]);\n"
                             "    if (q) texcoord.q = dot(gl_Vertex , gl_ObjectPlaneQ[unit]);\n"
                             "    return texcoord;\n"
                             "}\n"
                             "\n"
                             "vec4 texgen_SPHERE_MAP(vec4 texcoord, int unit, bool s, bool t, bool r, bool q)\n"
                             "{\n"
                             "    vec4 vertex_eye = gl_ModelViewMatrix * gl_Vertex;\n"
                             "    vec3 normalized_vertex_eye = normalize(vertex_eye.xyz);\n"
                             "    vec3 normal_eye = gl_NormalMatrix * gl_Normal;\n"
                             "    vec3 reflection_vector = reflect(normalized_vertex_eye, normal_eye);\n"
                             "    reflection_vector.z = reflection_vector.z + 1.0;\n"
                             "    float spheremap_m = 1.0 / (2.0 * length(reflection_vector));\n"
                             "    if (s) texcoord.s = reflection_vector.x * spheremap_m + 0.5;\n"
                             "    if (t) texcoord.t = reflection_vector.y * spheremap_m + 0.5;\n"
                             "    return texcoord;\n"
                             "}\n"
                             "\n"
                             "vec4 texgen_REFLECTION_MAP(vec4 texcoord, int unit, bool s, bool t, bool r, bool q)\n"
                             "{\n"
                             "    vec4 vertex_eye = gl_ModelViewMatrix * gl_Vertex;\n"
                             "    vec3 normalized_vertex_eye = normalize(vertex_eye.xyz);\n"
                             "    vec3 normal_eye = gl_NormalMatrix * gl_Normal;\n"
                             "    float m = 2.0 * dot(normalized_vertex_eye, normal_eye);\n"
                             "    if (s) texcoord.s = normalized_vertex_eye.x - normal_eye.x * m;\n"
                             "    if (t) texcoord.t = normalized_vertex_eye.y - normal_eye.y * m;\n"
                             "    if (r) texcoord.r = normalized_vertex_eye.z - normal_eye.z * m;\n"
                             "    return texcoord;\n"
                             "}\n"
                             "\n"
                             "vec4 texgen_NORMAL_MAP(vec4 texcoord, int unit, bool s, bool t, bool r, bool q)\n"
                             "{\n"
                             "    vec3 normal_eye = normalize(gl_NormalMatrix * gl_Normal);\n"
                             "    if (s) texcoord.s = normal_eye.s;\n"
                             "    if (t) texcoord.s = normal_eye.t;\n"
                             "    if (r) texcoord.s = normal_eye.r;\n"
                             "    return texcoord;\n"
                             "}\n"
                             "\n"
                             "#ifdef TEXTURE_VERT_DECLARE0\n"
                             "    TEXTURE_VERT_DECLARE0\n"
                             "#endif\n"
                             "\n"
                             "#ifdef TEXTURE_VERT_DECLARE1\n"
                             "    TEXTURE_VERT_DECLARE1\n"
                             "#endif\n"
                             "\n"
                             "#ifdef TEXTURE_VERT_DECLARE2\n"
                             "    TEXTURE_VERT_DECLARE2\n"
                             "#endif\n"
                             "\n"
                             "#ifdef TEXTURE_VERT_DECLARE3\n"
                             "    TEXTURE_VERT_DECLARE3\n"
                             "#endif\n"
                             "\n"
                             "#endif\n"
                             "\n"
                             "varying vec4 vertex_color;\n"
                             "\n"
                             "void main()\n"
                             "{\n"
                             "    vertex_color = gl_Color;\n"
                             "\n"
                             "#if GL_LIGHTING\n"
                             "    // for each active light source we need to do lighting\n"
                             "    #if GL_LIGHT0\n"
                             "        // vertex_color = vertex_color*0.25;\n"
                             "    #endif\n"
                             "#endif\n"
                             "\n"
                             "// for each active texture unit we need to do the following....\n"
                             "#if GL_MAX_TEXTURE_UNITS>0\n"
                             "\n"
                             "    #ifdef TEXTURE_VERT_BODY0\n"
                             "        TEXTURE_VERT_BODY0\n"
                             "\n"
                             "        #if defined(TEXTURE_GEN_FUNCTION0) && (GL_TEXTURE_GEN_S0 || GL_TEXTURE_GEN_T0 || GL_TEXTURE_GEN_R0 || GL_TEXTURE_GEN_Q0)\n"
                             "            TexCoord0 = TEXTURE_GEN_FUNCTION0(TexCoord0, 0, GL_TEXTURE_GEN_S0, GL_TEXTURE_GEN_T0, GL_TEXTURE_GEN_R0, GL_TEXTURE_GEN_Q0);\n"
                             "        #endif\n"
                             "\n"
                             "    #endif\n"
                             "\n"
                             "    #ifdef TEXTURE_VERT_BODY1\n"
                             "        TEXTURE_VERT_BODY1\n"
                             "\n"
                             "        #if defined(TEXTURE_GEN_BODY1) && (TEXTURE_GEN_S1 || TEXTURE_GEN_T1 || TEXTURE_GEN_R1 || TEXTURE_GEN_Q1)\n"
                             "            TexCoord1 = TEXTURE_GEN_FUNCTION1(TexCoord1, 1, GL_TEXTURE_GEN_S1, GL_TEXTURE_GEN_T1, GL_TEXTURE_GEN_R1, GL_TEXTURE_GEN_Q1);\n"
                             "        #endif\n"
                             "    #endif\n"
                             "\n"
                             "    #ifdef TEXTURE_VERT_BODY2\n"
                             "        TEXTURE_VERT_BODY2\n"
                             "\n"
                             "        #if defined(TEXTURE_GEN_BODY2) && (TEXTURE_GEN_S2 || TEXTURE_GEN_T2 || TEXTURE_GEN_R2 || TEXTURE_GEN_Q2)\n"
                             "            TexCoord2 = TEXTURE_GEN_FUNCTION2(TexCoord2, 2, GL_TEXTURE_GEN_S2, GL_TEXTURE_GEN_T2, GL_TEXTURE_GEN_R2, GL_TEXTURE_GEN_Q2);\n"
                             "        #endif\n"
                             "    #endif\n"
                             "\n"
                             "    #ifdef TEXTURE_VERT_BODY3\n"
                             "        TEXTURE_VERT_BODY3\n"
                             "\n"
                             "        #if defined(TEXTURE_GEN_BODY3) && (TEXTURE_GEN_S3 || TEXTURE_GEN_T3 || TEXTURE_GEN_R3 || TEXTURE_GEN_Q3)\n"
                             "            TexCoord3 = TEXTURE_GEN_FUNCTION3(TexCoord3, 3, GL_TEXTURE_GEN_S3, GL_TEXTURE_GEN_T3, GL_TEXTURE_GEN_R3, GL_TEXTURE_GEN_Q3);\n"
                             "        #endif\n"
                             "    #endif\n"
                             "\n"
                             "#endif\n"
                             "\n"
                             "    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n"
                             "\n"
                             "}\n";
