/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2;

import org.omegat.core.data.ProjectProperties;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;

public class FilterContext {
    private final Language sourceLang;
    private final Language targetLang;
    private String inEncoding;
    private String outEncoding;
    private boolean sentenceSegmentingEnabled;
    private boolean isRemoveAllTags;
    private Class<?> sourceTokenizerClass;
    private Class<?> targetTokenizerClass;

    public FilterContext(ProjectProperties props) {
        this.sourceLang = props.getSourceLanguage();
        this.targetLang = props.getTargetLanguage();
        this.sentenceSegmentingEnabled = props.isSentenceSegmentingEnabled();
        this.isRemoveAllTags = props.isRemoveTags();
        this.sourceTokenizerClass = props.getSourceTokenizer();
        this.targetTokenizerClass = props.getTargetTokenizer();
    }

    public FilterContext(Language sourceLang, Language targetLang, boolean sentenceSegmentingEnabled) {
        this.sourceLang = sourceLang;
        this.targetLang = targetLang;
        this.sentenceSegmentingEnabled = sentenceSegmentingEnabled;
        this.isRemoveAllTags = false;
    }

    public Language getSourceLang() {
        return this.sourceLang;
    }

    public Language getTargetLang() {
        return this.targetLang;
    }

    public String getInEncoding() {
        return this.inEncoding;
    }

    public FilterContext setInEncoding(String inEncoding) {
        this.inEncoding = inEncoding;
        return this;
    }

    public String getOutEncoding() {
        return this.outEncoding;
    }

    public FilterContext setOutEncoding(String outEncoding) {
        this.outEncoding = outEncoding;
        return this;
    }

    public boolean isSentenceSegmentingEnabled() {
        return this.sentenceSegmentingEnabled;
    }

    public boolean isRemoveAllTags() {
        return this.isRemoveAllTags;
    }

    public FilterContext setRemoveAllTags(boolean isRemoveAllTags) {
        this.isRemoveAllTags = isRemoveAllTags;
        return this;
    }

    public FilterContext setSourceTokenizerClass(Class<?> sourceTokenizerClass) {
        this.sourceTokenizerClass = sourceTokenizerClass;
        return this;
    }

    public ITokenizer getSourceTokenizer() {
        try {
            return (ITokenizer)this.sourceTokenizerClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public FilterContext setTargetTokenizerClass(Class<?> targetTokenizerClass) {
        this.targetTokenizerClass = targetTokenizerClass;
        return this;
    }

    public ITokenizer getTargetTokenizer() {
        try {
            return (ITokenizer)this.targetTokenizerClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

