/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex;
import org.tmatesoft.svn.core.internal.io.fs.index.FSPackedNumbersStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSLogicalAddressingIndex {
    public static final String L2P_STREAM_PREFIX = "L2P-INDEX\n";
    public static final String P2L_STREAM_PREFIX = "P2L-INDEX\n";
    private FSFile myFile;
    private long startRevision;
    private FSFS fsfs;

    public FSLogicalAddressingIndex(FSFS fsfs, FSFile myFile) {
        this.fsfs = fsfs;
        this.myFile = myFile;
        this.startRevision = -1L;
    }

    public long getStartRevision(long revision) {
        if (this.startRevision == -1L) {
            this.startRevision = this.fsfs.isPackedRevision(revision) ? revision - revision % this.fsfs.getMaxFilesPerDirectory() : revision;
        }
        return this.startRevision;
    }

    public long getOffsetByItemIndex(long revision, long itemIndex) throws SVNException {
        L2PPageInfo pageInfo = this.getL2PPageInfo(revision, itemIndex);
        boolean isPackedRevision = this.fsfs.isPackedRevision(revision);
        boolean isCached = false;
        long lastRevision = pageInfo.getFirstRevision() + (isPackedRevision ? this.fsfs.getMaxFilesPerDirectory() : 1L);
        PageTableEntry entry = pageInfo.getEntry();
        Page page = this.getL2PPage(entry);
        long offset = this.getL2PPageEntry(page, pageInfo.getPageOffset(), itemIndex, revision);
        return offset;
    }

    public long getItemIndexByOffset(long offset) {
        return -1L;
    }

    public List<FSP2LEntry> lookupP2LEntries(long revision, long blockStart, long blockEnd) throws SVNException {
        FSP2LEntry entry;
        long entryEnd;
        FSP2LEntry entry2;
        boolean isCached = false;
        ArrayList<FSP2LEntry> entries = new ArrayList<FSP2LEntry>();
        P2LPageInfo pageInfo = this.getP2LKeys(revision, blockStart);
        long originalPageStart = pageInfo.getPageStart();
        int leakingBucket = 4;
        P2LPageInfo prefetchInfo = pageInfo;
        long maxOffset = FSRepositoryUtil.align(pageInfo.getNextOffset(), this.fsfs.getBlockSize());
        long minOffset = FSRepositoryUtil.align(pageInfo.getStartOffset(), this.fsfs.getBlockSize()) - this.fsfs.getBlockSize();
        List<FSP2LEntry> pageEntries = this.getP2LPage(pageInfo.getFirstRevision(), pageInfo.getStartOffset(), pageInfo.getNextOffset(), pageInfo.getPageStart(), pageInfo.getPageSize());
        if (pageEntries.size() > 0 && (entry2 = pageEntries.get(pageEntries.size() - 1)).getOffset() + entry2.getSize() > pageInfo.getPageSize() * pageInfo.getPageCount()) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Last P2L index entry extends beyond the last page in revision {0}", (Object)new Long(revision));
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        this.appendP2LEntries(entries, pageEntries, blockStart, blockEnd);
        assert (entries.size() > 0);
        if (pageInfo.getPageNumber() + 1L >= pageInfo.getPageCount() && (entryEnd = (entry = (FSP2LEntry)entries.get(entries.size() - 1)).getOffset() + entry.getSize()) < blockEnd) {
            if (entry.getType() == FSP2LProtoIndex.ItemType.UNUSED) {
                entry.setSize(blockEnd - entry.getOffset());
            } else {
                entry = new FSP2LEntry(entryEnd, blockEnd - entryEnd, FSP2LProtoIndex.ItemType.UNUSED, 0, -1L, 0L);
                entries.add(entry);
            }
        }
        return entries;
    }

    protected P2LPageInfo getP2LKeys(long revision, long offset) throws SVNException {
        P2LPageInfo pageInfo = this.getP2LPageInfo(revision, offset);
        if (pageInfo.getPageCount() <= pageInfo.getPageNumber()) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Offset {0} too large in revision {1}", offset, revision);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        return pageInfo;
    }

    private P2LPageInfo getP2LPageInfo(long revision, long offset) throws SVNException {
        boolean isCached = false;
        if (isCached) {
            return null;
        }
        P2LIndexHeader header = this.getP2LHeader();
        return this.createPageInfo(header, revision, offset);
    }

    private P2LIndexHeader getP2LHeader() throws SVNException {
        long pageCount;
        long pageSize;
        long fileSize;
        boolean isCached = false;
        if (isCached) {
            return null;
        }
        FSPackedNumbersStream packedNumbersStream = this.autoOpenP2LIndex();
        packedNumbersStream.seek(0L);
        long firstRevision = packedNumbersStream.read();
        if (firstRevision != this.startRevision) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Index rev / pack file revision numbers do not match");
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        if ((fileSize = packedNumbersStream.read()) != this.myFile.getL2POffset()) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Index offset and rev / pack file size do not match");
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        if ((pageSize = packedNumbersStream.read()) == 0L || (pageSize & pageSize - 1L) != 0L) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "P2L index page size is not a power of two");
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        if ((pageCount = packedNumbersStream.read()) != (fileSize - 1L) / pageSize + 1L) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "P2L page count does not match rev / pack file size");
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        long[] offsets = new long[(int)(pageCount + 1L)];
        offsets[0] = 0L;
        int i = 0;
        while ((long)i < pageCount) {
            long value = packedNumbersStream.read();
            offsets[i + 1] = offsets[i] + value;
            ++i;
        }
        long offset = packedNumbersStream.position();
        int i2 = 0;
        while ((long)i2 <= pageCount) {
            int n = i2++;
            offsets[n] = offsets[n] + offset;
        }
        P2LIndexHeader p2LIndexHeader = new P2LIndexHeader(firstRevision, pageSize, pageCount, fileSize, offsets);
        return p2LIndexHeader;
    }

    private P2LPageInfo createPageInfo(P2LIndexHeader header, long revision, long offset) {
        P2LPageInfo pageInfo = new P2LPageInfo();
        if (offset / header.getPageSize() < header.getPageCount()) {
            pageInfo.setPageNumber(offset / header.getPageSize());
            pageInfo.setStartOffset(header.getOffsets()[(int)pageInfo.getPageNumber()]);
            pageInfo.setNextOffset(header.getOffsets()[(int)(pageInfo.getPageNumber() + 1L)]);
            pageInfo.setPageSize(header.getPageSize());
        } else {
            pageInfo.setPageNumber(header.getPageCount());
            pageInfo.setStartOffset(header.getOffsets()[(int)pageInfo.getPageNumber()]);
            pageInfo.setNextOffset(header.getOffsets()[(int)pageInfo.getPageNumber()]);
            pageInfo.setPageSize(0L);
        }
        pageInfo.setFirstRevision(header.getFirstRevision());
        pageInfo.setPageStart(header.getPageSize() * pageInfo.getPageNumber());
        pageInfo.setPageCount(header.getPageCount());
        return pageInfo;
    }

    private void appendP2LEntries(List<FSP2LEntry> entries, List<FSP2LEntry> pageEntries, long blockStart, long blockEnd) {
        FSP2LEntry entry;
        int idx = FSLogicalAddressingIndex.searchLowerBound(pageEntries, blockStart);
        if (idx > 0 && (entry = pageEntries.get(idx - 1)).getOffset() + entry.getSize() > blockStart) {
            --idx;
        }
        while (idx < pageEntries.size() && (entry = pageEntries.get(idx)).getOffset() < blockEnd) {
            entries.add(entry);
            ++idx;
        }
    }

    public static int searchLowerBound(List<FSP2LEntry> list, long key) {
        int lower = 0;
        int upper = list.size() - 1;
        while (lower <= upper) {
            int attempt = lower + (upper - lower) / 2;
            int cmp = FSLogicalAddressingIndex.compareEntryOffset(list.get(attempt), key);
            if (cmp < 0) {
                lower = attempt + 1;
                continue;
            }
            upper = attempt - 1;
        }
        assert (lower == upper + 1);
        return lower;
    }

    public static int compareEntryOffset(FSP2LEntry entry, long offset) {
        long diff = entry.getOffset() - offset;
        return diff < 0L ? -1 : (diff == 0L ? 0 : 1);
    }

    private List<FSP2LEntry> getP2LPage(long startRevision, long startOffset, long nextOffset, long pageStart, long pageSize) throws SVNException {
        ArrayList<FSP2LEntry> result = new ArrayList<FSP2LEntry>();
        FSPackedNumbersStream packedNumbersStream = this.autoOpenP2LIndex();
        packedNumbersStream.seek(startOffset);
        long[] itemOffset = new long[]{packedNumbersStream.read()};
        long[] lastRevision = new long[]{startRevision};
        long[] lastCompound = new long[]{0L};
        if (startOffset == nextOffset) {
            this.readEntryToList(packedNumbersStream, itemOffset, lastRevision, lastCompound, result);
        } else {
            long offset;
            do {
                this.readEntryToList(packedNumbersStream, itemOffset, lastRevision, lastCompound, result);
            } while ((offset = packedNumbersStream.read()) < nextOffset);
            if (offset == nextOffset) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "P2L page description overlaps with next page description");
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            if (itemOffset[0] < pageStart + pageSize) {
                itemOffset[0] = packedNumbersStream.read();
                lastRevision[0] = startRevision;
                lastCompound[0] = 0L;
                this.readEntryToList(packedNumbersStream, itemOffset, lastRevision, lastCompound, result);
            }
        }
        return result;
    }

    private void readEntryToList(FSPackedNumbersStream packedNumbersStream, long[] itemOffset, long[] lastRevision, long[] lastCompound, List<FSP2LEntry> result) throws SVNException {
        SVNErrorMessage errorMessage;
        SVNErrorMessage errorMessage2;
        long entryOffset = itemOffset[0];
        long entrySize = packedNumbersStream.read();
        lastCompound[0] = lastCompound[0] + packedNumbersStream.readSigned();
        FSP2LProtoIndex.ItemType entryType = FSP2LProtoIndex.ItemType.fromCode((int)(lastCompound[0] & 7L));
        long entryNumber = lastCompound[0] / 8L;
        if (entryType.getCode() > FSP2LProtoIndex.ItemType.CHANGES.getCode()) {
            errorMessage2 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Invalid item type in P2L index");
            SVNErrorManager.error(errorMessage2, SVNLogType.FSFS);
        }
        if (entryType == FSP2LProtoIndex.ItemType.CHANGES && entryNumber != 1L) {
            errorMessage2 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Changed path list must have item number 1");
            SVNErrorManager.error(errorMessage2, SVNLogType.FSFS);
        }
        lastRevision[0] = lastRevision[0] + packedNumbersStream.readSigned();
        long entryRevision = lastRevision[0];
        long entryChecksum = packedNumbersStream.read();
        if (entryChecksum > Integer.MAX_VALUE) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Invalid FNV1 checksum in P2L index");
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        if (entryType == FSP2LProtoIndex.ItemType.UNUSED && (entryNumber != 0L || entryChecksum != 0L)) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Empty regions must have item number 0 and checksum 0");
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        FSP2LEntry entry = new FSP2LEntry(entryOffset, entrySize, entryType, (int)entryChecksum, entryRevision, entryNumber);
        result.add(entry);
        itemOffset[0] = itemOffset[0] + entry.getSize();
    }

    private long getL2PPageEntry(Page page, long pageOffset, long itemIndex, long revision) throws SVNException {
        if (page.getEntryCount() <= pageOffset) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Item index {0} too large in revision {1}", itemIndex, revision);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        long[] offsets = page.getOffsets();
        return offsets[(int)pageOffset];
    }

    private Page getL2PPage(PageTableEntry tableEntry) throws SVNException {
        long entryCount = tableEntry.entryCount;
        long lastValue = 0L;
        long[] offsets = new long[(int)entryCount];
        FSPackedNumbersStream packedNumbersStream = this.autoOpenL2PIndex();
        packedNumbersStream.seek(tableEntry.offset);
        int i = 0;
        while ((long)i < entryCount) {
            long value = packedNumbersStream.readSigned();
            offsets[i] = (lastValue += value) - 1L;
            ++i;
        }
        if (packedNumbersStream.position() != tableEntry.offset + tableEntry.size) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "L2P actual page size does not match page table value");
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        return new Page(entryCount, offsets);
    }

    private L2PPageInfo getL2PPageInfo(long revision, long itemIndex) throws SVNException {
        L2PIndexHeader header = this.getL2PHeaderBody(revision);
        return this.createPageInfo(header, revision, itemIndex);
    }

    private L2PPageInfo createPageInfo(L2PIndexHeader header, long revision, long itemIndex) throws SVNException {
        long relativeRevision = revision - header.getFirstRevision();
        if (relativeRevision >= header.getRevisionCount()) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_REVISION, "Revision %ld not covered by item index", (Object)revision);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        PageTableEntry[] pageTable = header.getPageTable();
        long[] pageTableIndex = header.getPageTableIndex();
        L2PPageInfo pageInfo = new L2PPageInfo();
        pageInfo.setRevision(revision);
        pageInfo.setItemIndex(itemIndex);
        pageInfo.setFirstRevision(header.getFirstRevision());
        if (itemIndex < header.getPageSize()) {
            pageInfo.setPageOffset((int)itemIndex);
            pageInfo.setPageNumber(0);
            pageInfo.setEntry(pageTable[(int)pageTableIndex[(int)relativeRevision]]);
        } else {
            long maxItemIndex = header.getPageSize() * (pageTableIndex[(int)(relativeRevision + 1L)] - pageTableIndex[(int)relativeRevision]);
            if (itemIndex >= maxItemIndex) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Item index {0} exceeds l2p limit of {1} for revision {2}", itemIndex, maxItemIndex, revision);
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            pageInfo.setPageOffset((int)(itemIndex % header.getPageSize()));
            pageInfo.setPageNumber((int)(itemIndex / header.getPageSize()));
            pageInfo.setEntry(pageTable[(int)(pageTableIndex[(int)relativeRevision] + (long)pageInfo.getPageNumber())]);
        }
        return pageInfo;
    }

    private L2PIndexHeader getL2PHeaderBody(long revision) throws SVNException {
        SVNErrorMessage errorMessage;
        long value;
        SVNErrorMessage errorMessage2;
        long pageCount;
        long revisionCount;
        long pageSize;
        FSPackedNumbersStream packedNumbersStream = this.autoOpenL2PIndex();
        packedNumbersStream.seek(0L);
        long firstRevision = packedNumbersStream.read();
        if (firstRevision != this.getStartRevision(revision)) {
            SVNErrorMessage errorMessage3 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Index rev / pack file revision numbers do not match");
            SVNErrorManager.error(errorMessage3, SVNLogType.FSFS);
        }
        if ((pageSize = packedNumbersStream.read()) == 0L || (pageSize & pageSize - 1L) != 0L) {
            SVNErrorMessage errorMessage4 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "L2P index page size is not a power of two");
            SVNErrorManager.error(errorMessage4, SVNLogType.FSFS);
        }
        if ((revisionCount = packedNumbersStream.read()) != 1L && revisionCount != this.fsfs.getMaxFilesPerDirectory()) {
            SVNErrorMessage errorMessage5 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Invalid number of revisions in L2P index");
            SVNErrorManager.error(errorMessage5, SVNLogType.FSFS);
        }
        if ((pageCount = packedNumbersStream.read()) < revisionCount) {
            errorMessage2 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Fewer L2P index pages than revisions");
            SVNErrorManager.error(errorMessage2, SVNLogType.FSFS);
        }
        if (pageCount > (this.myFile.getP2LOffset() - this.myFile.getL2POffset()) / 2L) {
            errorMessage2 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "L2P index page count implausibly large");
            SVNErrorManager.error(errorMessage2, SVNLogType.FSFS);
        }
        long nextRevision = firstRevision + revisionCount;
        if (firstRevision > revision || nextRevision <= revision) {
            SVNErrorMessage errorMessage6 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Corrupt L2P index for r{0} only covers r{1}:{2}", revision, firstRevision, nextRevision);
            SVNErrorManager.error(errorMessage6, SVNLogType.FSFS);
        }
        PageTableEntry[] pageTable = new PageTableEntry[(int)pageCount];
        long[] pageTableIndex = new long[(int)(revisionCount + 1L)];
        pageTableIndex[0] = 0L;
        long index = 0L;
        int i = 0;
        while ((long)i < revisionCount) {
            value = packedNumbersStream.read();
            if (value == 0L) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Revision with no L2P index pages");
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            if ((index += value) > pageCount) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "L2P page table exceeded");
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            pageTableIndex[i + 1] = index;
            ++i;
        }
        if (index != pageCount) {
            SVNErrorMessage errorMessage7 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Revisions do not cover the full L2P index page table");
            SVNErrorManager.error(errorMessage7, SVNLogType.FSFS);
        }
        int page = 0;
        while ((long)page < pageCount) {
            value = packedNumbersStream.read();
            if (value == 0L) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Empty L2P index page");
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            pageTable[page] = new PageTableEntry();
            pageTable[page].size = value;
            value = packedNumbersStream.read();
            if (value > pageSize) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Page exceeds L2P index page size");
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            pageTable[page].entryCount = value;
            ++page;
        }
        long offset = packedNumbersStream.position();
        int page2 = 0;
        while ((long)page2 < pageCount) {
            pageTable[page2].offset = offset;
            offset += pageTable[page2].size;
            ++page2;
        }
        L2PIndexHeader indexHeader = new L2PIndexHeader(firstRevision, revisionCount, pageSize, pageTableIndex, pageTable);
        return indexHeader;
    }

    private FSPackedNumbersStream autoOpenP2LIndex() throws SVNException {
        this.myFile.ensureFooterLoaded();
        FSPackedNumbersStream packedNumbersStream = this.packedStreamOpen(P2L_STREAM_PREFIX);
        return packedNumbersStream;
    }

    private FSPackedNumbersStream autoOpenL2PIndex() throws SVNException {
        this.myFile.ensureFooterLoaded();
        FSPackedNumbersStream packedNumbersStream = this.packedStreamOpen(L2P_STREAM_PREFIX);
        return packedNumbersStream;
    }

    private FSPackedNumbersStream packedStreamOpen(String prefix) throws SVNException {
        this.myFile.seek(this.myFile.getL2POffset());
        int length = prefix.length();
        byte[] headerBytes = new byte[length];
        try {
            int bytesRead = this.myFile.read(headerBytes, 0, length);
            if (bytesRead != length) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION);
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        if (!Arrays.equals(headerBytes, prefix.getBytes())) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Index stream header prefix mismatch.\n  expected: {0}  found: {1}", prefix, new String(headerBytes));
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        return new FSPackedNumbersStream(this.myFile);
    }

    private static class Page {
        long entryCount;
        long[] offsets;

        public Page(long entryCount, long[] offsets) {
            this.entryCount = entryCount;
            this.offsets = offsets;
        }

        public long getEntryCount() {
            return this.entryCount;
        }

        public long[] getOffsets() {
            return this.offsets;
        }
    }

    private static class P2LIndexHeader {
        private long firstRevision;
        private long pageSize;
        private long pageCount;
        private long fileSize;
        private long[] offsets;

        public P2LIndexHeader(long firstRevision, long pageSize, long pageCount, long fileSize, long[] offsets) {
            this.firstRevision = firstRevision;
            this.pageSize = pageSize;
            this.pageCount = pageCount;
            this.fileSize = fileSize;
            this.offsets = offsets;
        }

        public long getFirstRevision() {
            return this.firstRevision;
        }

        public long getPageSize() {
            return this.pageSize;
        }

        public long getPageCount() {
            return this.pageCount;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public long[] getOffsets() {
            return this.offsets;
        }
    }

    private static class P2LPageInfo {
        private long revision;
        private long offset;
        private long pageNumber;
        private long firstRevision;
        private long startOffset;
        private long nextOffset;
        private long pageStart;
        private long pageCount;
        private long pageSize;

        private P2LPageInfo() {
        }

        public long getRevision() {
            return this.revision;
        }

        public void setRevision(long revision) {
            this.revision = revision;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public long getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(long pageNumber) {
            this.pageNumber = pageNumber;
        }

        public long getFirstRevision() {
            return this.firstRevision;
        }

        public void setFirstRevision(long firstRevision) {
            this.firstRevision = firstRevision;
        }

        public long getStartOffset() {
            return this.startOffset;
        }

        public void setStartOffset(long startOffset) {
            this.startOffset = startOffset;
        }

        public long getNextOffset() {
            return this.nextOffset;
        }

        public void setNextOffset(long nextOffset) {
            this.nextOffset = nextOffset;
        }

        public long getPageStart() {
            return this.pageStart;
        }

        public void setPageStart(long pageStart) {
            this.pageStart = pageStart;
        }

        public long getPageCount() {
            return this.pageCount;
        }

        public void setPageCount(long pageCount) {
            this.pageCount = pageCount;
        }

        public long getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(long pageSize) {
            this.pageSize = pageSize;
        }
    }

    private static class L2PPageInfo {
        private long revision;
        private long itemIndex;
        private PageTableEntry entry;
        private int pageNumber;
        private int pageOffset;
        private long firstRevision;

        private L2PPageInfo() {
        }

        public long getRevision() {
            return this.revision;
        }

        public void setRevision(long revision) {
            this.revision = revision;
        }

        public long getItemIndex() {
            return this.itemIndex;
        }

        public void setItemIndex(long itemIndex) {
            this.itemIndex = itemIndex;
        }

        public PageTableEntry getEntry() {
            return this.entry;
        }

        public void setEntry(PageTableEntry entry) {
            this.entry = entry;
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
        }

        public int getPageOffset() {
            return this.pageOffset;
        }

        public void setPageOffset(int pageOffset) {
            this.pageOffset = pageOffset;
        }

        public long getFirstRevision() {
            return this.firstRevision;
        }

        public void setFirstRevision(long firstRevision) {
            this.firstRevision = firstRevision;
        }
    }

    private static class PageTableEntry {
        private long offset;
        private long entryCount;
        private long size;

        private PageTableEntry() {
        }
    }

    private static class L2PIndexHeader {
        private long firstRevision;
        private long revisionCount;
        private long pageSize;
        private long[] pageTableIndex;
        private PageTableEntry[] pageTable;

        public L2PIndexHeader(long firstRevision, long revisionCount, long pageSize, long[] pageTableIndex, PageTableEntry[] pageTable) {
            this.firstRevision = firstRevision;
            this.revisionCount = revisionCount;
            this.pageSize = pageSize;
            this.pageTableIndex = pageTableIndex;
            this.pageTable = pageTable;
        }

        public long getFirstRevision() {
            return this.firstRevision;
        }

        public long getRevisionCount() {
            return this.revisionCount;
        }

        public long getPageSize() {
            return this.pageSize;
        }

        public long[] getPageTableIndex() {
            return this.pageTableIndex;
        }

        public PageTableEntry[] getPageTable() {
            return this.pageTable;
        }
    }
}

