/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.JAXB.JAXBTmx;
import org.madlonkay.supertmxmerge.gui.ProgressWindow;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public abstract class FileLoaderWorker
extends SwingWorker<List<ITmx>, Object[]> {
    private final File[] files;
    protected final ProgressWindow progress = new ProgressWindow();

    public FileLoaderWorker(File ... files) {
        this.progress.setMaximum(files.length);
        this.files = files;
    }

    @Override
    protected List<ITmx> doInBackground() throws Exception {
        ArrayList<ITmx> result = new ArrayList<ITmx>(this.files.length);
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            this.publish((V[])new Object[][]{{i, LocString.getFormat("STM_FILE_PROGRESS", file.getName(), i + 1, this.files.length)}});
            result.add(new JAXBTmx(file));
        }
        this.publish((V[])new Object[][]{{this.files.length}});
        return result;
    }

    @Override
    protected void process(List<Object[]> chunks) {
        Object[] last = chunks.get(chunks.size() - 1);
        this.progress.setValue((Integer)last[0]);
        if (last.length > 1) {
            this.progress.setMessage((String)last[1]);
        }
    }

    @Override
    protected void done() {
        List result;
        try {
            result = (List)this.get();
        }
        catch (Exception ex) {
            GuiUtil.showError(LocString.getFormat("STM_LOAD_ERROR", ex));
            throw new RuntimeException(ex);
        }
        finally {
            GuiUtil.closeWindow(this.progress);
        }
        this.processLoadedTmxs(result);
    }

    protected abstract void processLoadedTmxs(List<ITmx> var1);
}

