/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.calculator.length;

import java.util.ArrayList;
import java.util.List;
import net.loomchild.maligna.calculator.length.LengthCalculator;
import net.loomchild.maligna.calculator.length.counter.Counter;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.model.length.LengthModel;
import net.loomchild.maligna.model.length.LengthModelUtil;

public class PoissonDistributionCalculator
extends LengthCalculator {
    private LengthModel sourceLengthModel;
    private LengthModel targetLengthModel;
    private float meanLengthRatio;

    public PoissonDistributionCalculator(Counter counter, List<Alignment> alignmentList) {
        super(counter);
        ArrayList<String> sourceSegmentList = new ArrayList<String>();
        ArrayList<String> targetSegmentList = new ArrayList<String>();
        for (Alignment alignment : alignmentList) {
            sourceSegmentList.addAll(alignment.getSourceSegmentList());
            targetSegmentList.addAll(alignment.getTargetSegmentList());
        }
        this.sourceLengthModel = this.trainLengthModel(sourceSegmentList);
        this.targetLengthModel = this.trainLengthModel(targetSegmentList);
        this.meanLengthRatio = this.targetLengthModel.getMeanLength() / this.sourceLengthModel.getMeanLength();
    }

    private LengthModel trainLengthModel(List<String> segmentList) {
        List<Integer> lengthList = this.calculateLengthList(segmentList);
        LengthModel lengthModel = LengthModelUtil.train(lengthList);
        return lengthModel;
    }

    @Override
    protected float calculateLengthScore(List<Integer> sourceLengthList, List<Integer> targetLengthList) {
        float score;
        if (sourceLengthList.size() == 0 && targetLengthList.size() == 0) {
            score = 0.0f;
        } else if (sourceLengthList.size() == 0) {
            score = this.calculateLanguageScore(targetLengthList, this.targetLengthModel);
        } else {
            score = this.calculateLanguageScore(sourceLengthList, this.sourceLengthModel);
            if (targetLengthList.size() > 0) {
                score += this.calculateTranslationScore(sourceLengthList, targetLengthList);
            }
        }
        assert (score >= 0.0f);
        return score;
    }

    private float calculateLanguageScore(List<Integer> lengthList, LengthModel lengthModel) {
        float score = 0.0f;
        for (int length : lengthList) {
            score = (float)((double)score + -Math.log(lengthModel.getLengthProbability(length)));
        }
        assert (score >= 0.0f);
        return score;
    }

    private float calculateTranslationScore(List<Integer> sourceLengthList, List<Integer> targetLengthList) {
        int sourceTotalLength = this.calculateTotalLength(sourceLengthList);
        int targetTotalLength = this.calculateTotalLength(targetLengthList);
        float mean = (float)sourceTotalLength * this.meanLengthRatio;
        float score = PoissonDistributionCalculator.poissonDistribution(mean, targetTotalLength);
        assert (score >= 0.0f);
        return score;
    }

    static float poissonDistribution(float mean, int x) {
        assert (mean > 0.0f);
        return mean + (float)(-x) * (float)Math.log(mean) + PoissonDistributionCalculator.factorial(x);
    }

    static float factorial(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("Cannot calculate factorial for a negative number: " + x + ".");
        }
        float y = 0.0f;
        for (int i = 2; i <= x; ++i) {
            y = (float)((double)y + Math.log(i));
        }
        return y;
    }
}

