/**
 * The UIEvent interface provides specific contextual information associated with User Interface events.
 */
var UIEvent = {
}
/**
 * Specifies some detail information about the Event, depending on the type of event.
 * @syntax uIEvent.detail
 * @returns {Number} 
 */
UIEvent.prototype.detail = new Number();

/**
 * The initUIEvent method is used to initialize the value of a UIEvent created through the DocumentEvent interface. This method may only be called before the UIEvent has been dispatched via the dispatchEvent method, though it may be called multiple times during that phase if necessary. If called multiple times, the final invocation takes precedence.
 * @syntax uIEvent.initUIEvent(typeArg, canBubbleArg, cancelableArg, viewArg, detailArg)
 * @param {String} typeArg Specifies the event type.
 * @param {boolean} canBubbleArg Specifies whether or not the event can bubble.
 * @param {boolean} cancelableArg Specifies whether or not the event's default action can be prevented.
 * @param {views::AbstractView} viewArg Specifies the Event's AbstractView.
 * @param {Number} detailArg Specifies the Event's detail.
 * @returns {undefined} 
 */
UIEvent.prototype.initUIEvent = function(typeArg,  canBubbleArg,  cancelableArg,  viewArg,  detailArg) {};

/**
 * The view attribute identifies the AbstractView from which the event was generated.
 * @syntax uIEvent.view
 * @returns {views::AbstractView} 
 */
UIEvent.prototype.view = new views::AbstractView();

/**
 * Represents the UIEvent prototype object.
 * @syntax UIEvent.prototype
 * @static
 */
UIEvent.prototype;

