/**
 * The CSSRule interface is the abstract base interface for any type of CSS statement. This includes both rule sets and at-rules. An implementation is expected to preserve all rules specified in a CSS style sheet, even if the rule is not recognized by the parser. Unrecognized rules are represented using the CSSUnknownRule interface.
 */
var CSSRule = {
}
/**
 * If this rule is contained inside another rule (e.g. a style rule inside an @media block), this is the containing rule. If this rule is not nested inside any other rules, this returns null.
 * @syntax cSSRule.parentRule
 * @returns {CSSRule} 
 */
CSSRule.prototype.parentRule = new CSSRule();

/**
 * The rule is a CSSCharsetRule.
 * @syntax CSSRule.CHARSET_RULE
 * @returns {Number} 
 * @static
 */
CSSRule.CHARSET_RULE = new Number();

/**
 * The rule is a CSSStyleRule.
 * @syntax CSSRule.STYLE_RULE
 * @returns {Number} 
 * @static
 */
CSSRule.STYLE_RULE = new Number();

/**
 * The rule is a CSSUnknownRule.
 * @syntax CSSRule.UNKNOWN_RULE
 * @returns {Number} 
 * @static
 */
CSSRule.UNKNOWN_RULE = new Number();

/**
 * The rule is a CSSImportRule.
 * @syntax CSSRule.IMPORT_RULE
 * @returns {Number} 
 * @static
 */
CSSRule.IMPORT_RULE = new Number();

/**
 * The parsable textual representation of the rule. This reflects the current state of the rule and not its initial value. Exceptions on setting DOMException SYNTAX_ERR: Raised if the specified CSS string value has a syntax error and is unparsable. INVALID_MODIFICATION_ERR: Raised if the specified CSS string value represents a different type of rule than the current one. HIERARCHY_REQUEST_ERR: Raised if the rule cannot be inserted at this point in the style sheet. NO_MODIFICATION_ALLOWED_ERR: Raised if the rule is readonly.
 * @syntax cSSRule.cssText
 * @returns {String} 
 */
CSSRule.prototype.cssText = new String();

/**
 * The rule is a CSSFontFaceRule.
 * @syntax CSSRule.FONT_FACE_RULE
 * @returns {Number} 
 * @static
 */
CSSRule.FONT_FACE_RULE = new Number();

/**
 * The rule is a CSSMediaRule.
 * @syntax CSSRule.MEDIA_RULE
 * @returns {Number} 
 * @static
 */
CSSRule.MEDIA_RULE = new Number();

/**
 * The type of the rule, as defined above. The expectation is that binding-specific casting methods can be used to cast down from an instance of the CSSRule interface to the specific derived interface implied by the type.
 * @syntax cSSRule.type
 * @returns {Number} 
 */
CSSRule.prototype.type = new Number();

/**
 * The rule is a CSSPageRule.
 * @syntax CSSRule.PAGE_RULE
 * @returns {Number} 
 * @static
 */
CSSRule.PAGE_RULE = new Number();

/**
 * The style sheet that contains this rule.
 * @syntax cSSRule.parentStyleSheet
 * @returns {CSSStyleSheet} 
 */
CSSRule.prototype.parentStyleSheet = new CSSStyleSheet();

/**
 * Represents the CSSRule prototype object.
 * @syntax CSSRule.prototype
 * @static
 */
CSSRule.prototype;

