/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.annotation.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.openide.util.Parameters;

public class AnnotationUtils {
    private static final String PARAM_TYPE_PATTERN = "\\s*=\\s*(\\\"?)\\s*([\\w\\\\]+)(?:::class)?\\s*\\1";
    private static final Pattern INLINE_TYPE_PATTERN = Pattern.compile("@([\\w\\\\]+)");

    private AnnotationUtils() {
    }

    public static boolean isTypeAnnotation(@NonNull String lineToCheck, @NonNull String annotationName) {
        Parameters.notNull((CharSequence)"lineToCheck", (Object)lineToCheck);
        Parameters.notNull((CharSequence)"annotationName", (Object)annotationName);
        return lineToCheck.toLowerCase().matches("\\\\?(\\w+\\\\)*" + annotationName.toLowerCase() + "\\s*");
    }

    public static Map<OffsetRange, String> extractTypesFromParameters(@NonNull String line, @NonNull Set<String> parameterNameRegexs) {
        Parameters.notNull((CharSequence)"line", (Object)line);
        Parameters.notNull((CharSequence)"parameterNameRegexs", parameterNameRegexs);
        HashMap<OffsetRange, String> result = new HashMap<OffsetRange, String>();
        for (String parameterNameRegex : parameterNameRegexs) {
            Pattern pattern = Pattern.compile(parameterNameRegex + PARAM_TYPE_PATTERN);
            Matcher matcher = pattern.matcher(line);
            while (matcher.find()) {
                int lastGroupId = matcher.groupCount();
                result.put(new OffsetRange(matcher.start(lastGroupId), matcher.end(lastGroupId)), matcher.group(lastGroupId));
            }
        }
        return result;
    }

    public static Map<OffsetRange, String> extractInlineAnnotations(@NonNull String line, @NonNull Set<String> expectedAnnotations) {
        Parameters.notNull((CharSequence)"line", (Object)line);
        Parameters.notNull((CharSequence)"expectedAnnotations", expectedAnnotations);
        HashMap<OffsetRange, String> result = new HashMap<OffsetRange, String>();
        Matcher matcher = INLINE_TYPE_PATTERN.matcher(line);
        while (matcher.find()) {
            if (!AnnotationUtils.isExpectedType(matcher.group(1), expectedAnnotations)) continue;
            result.put(new OffsetRange(matcher.start(1), matcher.end(1)), matcher.group(1));
        }
        return result;
    }

    private static boolean isExpectedType(@NonNull String typeName, @NonNull Set<String> expectedTypes) {
        Parameters.notNull((CharSequence)"typeName", (Object)typeName);
        Parameters.notNull((CharSequence)"expectedTypes", expectedTypes);
        boolean result = false;
        for (String annotation : expectedTypes) {
            if (!typeName.toLowerCase().endsWith(annotation.toLowerCase())) continue;
            result = true;
            break;
        }
        return result;
    }
}

