/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class LabelRenderer
extends JLabel
implements ProfilerRenderer {
    private static final LabelRendererUI UI = new LabelRendererUI();
    private static final int DIRTY = Integer.MIN_VALUE;
    private Dimension preferredSize;
    private int iconWidth;
    private int iconHeight;
    private int iconTextGap;
    private int textWidth;
    private int fontAscent;
    private Point sharedPoint;
    private Dimension sharedDimension;
    private Rectangle sharedRectangle;
    protected final Point location = new Point();
    protected final Dimension size = new Dimension();
    private final Insets insets = new Insets(0, 0, 0, 0);
    private final Insets margin = new Insets(0, 0, 0, 0);
    private FontMetrics fontMetrics;
    private int fontSizeDiff;
    private String text;
    private Icon icon;
    private Color foreground;
    private Color background;
    private boolean enabled = true;

    public LabelRenderer() {
        this(false);
    }

    public LabelRenderer(boolean plain) {
        this.setHorizontalAlignment(10);
        this.setVerticalAlignment(1);
        this.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (plain) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
            this.setMargin(3, 3, 3, 3);
        }
        this.iconTextGap = super.getIconTextGap();
    }

    @Override
    public void setValue(Object value, int row) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public void setUI(LabelUI ui) {
        super.setUI(UI);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.sharedDimension(this.getPreferredSizeImpl());
    }

    public Dimension getPreferredSizeImpl() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        if (this.preferredSize.width == Integer.MIN_VALUE) {
            this.textWidth = this.text == null || this.text.isEmpty() ? 0 : this.fontMetrics.stringWidth(this.text);
            this.preferredSize.width = this.iconWidth + this.textWidth;
            this.preferredSize.width += this.margin.left + this.margin.right;
            if (this.iconWidth > 0 && this.textWidth > 0) {
                this.preferredSize.width += this.iconTextGap;
            }
        }
        if (this.preferredSize.height == Integer.MIN_VALUE) {
            this.fontAscent = this.fontMetrics.getAscent();
            this.preferredSize.height = this.fontAscent + this.fontMetrics.getDescent();
            this.preferredSize.height += this.margin.top + this.margin.bottom;
        }
        return this.preferredSize;
    }

    private void resetPreferredSize(boolean width, boolean height) {
        if (this.preferredSize == null) {
            return;
        }
        if (width) {
            this.preferredSize.width = Integer.MIN_VALUE;
        }
        if (height) {
            this.preferredSize.height = Integer.MIN_VALUE;
        }
    }

    @Override
    public void paint(Graphics g) {
        int yy;
        int xx = this.location.x;
        int h = this.size.height;
        int hh = this.getPreferredSizeImpl().height;
        if (this.background != null && this.isOpaque()) {
            g.setColor(this.background);
            g.fillRect(xx, this.location.y, this.size.width, h);
        }
        g.setFont(this.getFont());
        int hAlign = this.getHorizontalAlignment();
        if (hAlign == 10) {
            xx += this.margin.left;
        } else if (hAlign == 0) {
            int w = this.size.width - this.textWidth - this.iconWidth;
            if (this.textWidth > 0 && this.iconWidth > 0) {
                w -= this.iconTextGap;
            }
            xx += Math.max(this.margin.left, w / 2);
        } else {
            xx += this.size.width - this.margin.right - this.textWidth;
            if (this.iconWidth > 0) {
                xx += -this.iconWidth - this.iconTextGap;
            }
        }
        if (this.iconWidth > 0) {
            yy = (h - this.iconHeight) / 2;
            this.icon.paintIcon(this, g, xx, this.location.y + yy);
            xx += this.iconWidth + this.iconTextGap;
        }
        if (this.textWidth > 0) {
            yy = (h - hh - this.fontSizeDiff) / 2 + this.margin.top;
            UI.paintEnabledText(this, g, this.text, xx, this.location.y + yy + this.fontAscent);
        }
    }

    protected final Point sharedPoint(int x, int y) {
        if (this.sharedPoint == null) {
            this.sharedPoint = new Point();
        }
        this.sharedPoint.x = x;
        this.sharedPoint.y = y;
        return this.sharedPoint;
    }

    protected final Point sharedPoint(Point point) {
        return this.sharedPoint(point.x, point.y);
    }

    protected final Dimension sharedDimension(int width, int height) {
        if (this.sharedDimension == null) {
            this.sharedDimension = new Dimension();
        }
        this.sharedDimension.width = width;
        this.sharedDimension.height = height;
        return this.sharedDimension;
    }

    protected final Dimension sharedDimension(Dimension dimension) {
        return this.sharedDimension(dimension.width, dimension.height);
    }

    protected final Rectangle sharedRectangle(int x, int y, int width, int height) {
        if (this.sharedRectangle == null) {
            this.sharedRectangle = new Rectangle();
        }
        this.sharedRectangle.x = x;
        this.sharedRectangle.y = y;
        this.sharedRectangle.width = width;
        this.sharedRectangle.height = height;
        return this.sharedRectangle;
    }

    protected final Rectangle sharedRectangle(Rectangle rectangle) {
        return this.sharedRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void move(int x, int y) {
        this.location.x = x;
        this.location.y = y;
    }

    @Override
    public Point getLocation() {
        return this.sharedPoint(this.location);
    }

    @Override
    public int getX() {
        return this.location.x;
    }

    @Override
    public int getY() {
        return this.location.y;
    }

    @Override
    public void setSize(int w, int h) {
        this.size.width = w;
        this.size.height = h;
    }

    @Override
    public Dimension getSize() {
        return this.sharedDimension(this.size);
    }

    @Override
    public int getWidth() {
        return this.size.width;
    }

    @Override
    public int getHeight() {
        return this.size.height;
    }

    @Override
    public Rectangle getBounds() {
        return this.sharedRectangle(this.location.x, this.location.y, this.size.width, this.size.height);
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        this.size.width = w;
        this.size.height = h;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.insets;
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.margin.top = top;
        this.margin.left = left;
        this.margin.bottom = bottom;
        this.margin.right = right;
        this.resetPreferredSize(true, true);
    }

    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.resetPreferredSize(true, false);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
        this.iconWidth = icon == null ? 0 : icon.getIconWidth();
        this.iconHeight = icon == null ? 0 : icon.getIconHeight();
        this.resetPreferredSize(true, false);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.fontMetrics;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = super.getFontMetrics(font);
        this.resetPreferredSize(true, true);
    }

    public void changeFontSize(int diff) {
        this.fontSizeDiff = diff;
        Font font = this.getFont();
        this.setFont(font.deriveFont(font.getSize2D() + (float)diff));
    }

    @Override
    public int getIconTextGap() {
        return this.iconTextGap;
    }

    @Override
    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
        this.resetPreferredSize(true, false);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void setDisplayedMnemonic(int key) {
    }

    @Override
    public void setDisplayedMnemonic(char aChar) {
    }

    @Override
    public void setDisplayedMnemonicIndex(int index) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    private static final class LabelRendererUI
    extends BasicLabelUI {
        private LabelRendererUI() {
        }

        @Override
        protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
            super.paintEnabledText(l, g, s, textX, textY);
        }
    }
}

