/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsDiff;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.jdbc.JDBCTreeTableView;
import org.netbeans.lib.profiler.ui.jdbc.JDBCView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class LiveJDBCView
extends JPanel {
    private JdbcResultsSnapshot snapshot;
    private JdbcResultsSnapshot refSnapshot;
    private DataView lastFocused;
    private JDBCTreeTableView jdbcCallsView;
    private long lastupdate;
    private volatile boolean refreshIsRunning;
    private ExecutorService executor;

    public LiveJDBCView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.initUI(selection);
        this.registerActions();
    }

    public void setView(boolean forwardCalls, boolean hotSpots, boolean reverseCalls) {
        this.jdbcCallsView.setVisible(forwardCalls);
    }

    public boolean isRefreshRunning() {
        return this.refreshIsRunning;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public void setData(final JdbcResultsSnapshot snapshotData) {
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.snapshot = snapshotData;
                LiveJDBCView.this.setData();
            }
        });
    }

    private void setData() {
        if (this.snapshot == null) {
            this.resetData();
            this.refreshIsRunning = false;
        } else {
            this.getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    final JdbcResultsSnapshot _snapshot = LiveJDBCView.this.refSnapshot == null ? LiveJDBCView.this.snapshot : LiveJDBCView.this.refSnapshot.createDiff(LiveJDBCView.this.snapshot);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                boolean diff = _snapshot instanceof JdbcResultsDiff;
                                LiveJDBCView.this.jdbcCallsView.setData(_snapshot, null, -1, null, false, false, diff);
                            }
                            finally {
                                LiveJDBCView.this.refreshIsRunning = false;
                                LiveJDBCView.this.lastupdate = System.currentTimeMillis();
                            }
                        }
                    });
                }
            });
        }
    }

    public boolean setDiffView(final boolean diff) {
        if (this.snapshot == null) {
            return false;
        }
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.refSnapshot = diff ? LiveJDBCView.this.snapshot : null;
                LiveJDBCView.this.setData();
            }
        });
        return true;
    }

    public void resetData() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.jdbcCallsView.resetData();
                LiveJDBCView.this.snapshot = null;
                LiveJDBCView.this.refSnapshot = null;
            }
        });
    }

    public void showSelectionColumn() {
        this.jdbcCallsView.showSelectionColumn();
    }

    public void refreshSelection() {
        this.jdbcCallsView.refreshSelection();
    }

    public void cleanup() {
    }

    protected abstract ProfilerClient getProfilerClient();

    protected boolean profileMethodSupported() {
        return true;
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void showSQLQuery(String var1, String var2);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void profileMethod(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(value);
    }

    private void profileClass(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(value.getClassName(), "*", null));
    }

    private void initUI(Set<ClientUtils.SourceCodeSelection> selection) {
        this.setLayout(new BorderLayout(0, 0));
        this.jdbcCallsView = new JDBCTreeTableView(selection, false){

            @Override
            protected void installDefaultAction() {
                this.getResultsComponent().setDefaultAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row;
                        ProfilerTable t = this.getResultsComponent();
                        PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)t.getValueForRow(row = t.getSelectedRow());
                        if (JDBCTreeTableView.isSQL(node)) {
                            LiveJDBCView.this.showQueryImpl(node);
                        } else {
                            ClientUtils.SourceCodeSelection userValue = this.getUserValueForRow(row);
                            if (userValue != null) {
                                this.performDefaultAction(userValue);
                            }
                        }
                    }
                });
            }

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveJDBCView.this.showSourceSupported()) {
                    LiveJDBCView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveJDBCView.this.populatePopup(LiveJDBCView.this.jdbcCallsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveJDBCView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveJDBCView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.jdbcCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.lastFocused = LiveJDBCView.this.jdbcCallsView;
            }
        });
        this.add((Component)this.jdbcCallsView, "Center");
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveJDBCView.this.getLastFocused();
                if (active != null) {
                    active.activateFilter();
                }
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveJDBCView.this.getLastFocused();
                if (active != null) {
                    active.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null && this.jdbcCallsView.isShowing()) {
            this.lastFocused = this.jdbcCallsView;
        }
        return this.lastFocused;
    }

    private void showQueryImpl(PresoObjAllocCCTNode node) {
        this.showSQLQuery(node.getNodeName(), ((JDBCTreeTableView.SQLQueryNode)node).htmlName);
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, final Object value, final ClientUtils.SourceCodeSelection userValue) {
        JMenuItem[] customItems;
        final PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)value;
        if (JDBCTreeTableView.isSQL(node)) {
            popup.add(new JMenuItem(JDBCView.ACTION_VIEWSQLQUERY){
                {
                    super(x0);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveJDBCView.this.showQueryImpl((JDBCTreeTableView.SQLQueryNode)((Object)value));
                }
            });
            popup.addSeparator();
        } else if (this.showSourceSupported()) {
            popup.add(new JMenuItem(JDBCView.ACTION_GOTOSOURCE){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveJDBCView.this.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        if (this.profileMethodSupported()) {
            popup.add(new JMenuItem(JDBCView.ACTION_PROFILE_METHOD){
                {
                    super(x0);
                    this.setEnabled(userValue != null && JDBCTreeTableView.isSelectable(node));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveJDBCView.this.profileMethod(userValue);
                }
            });
        }
        if (this.profileClassSupported()) {
            popup.add(new JMenuItem(JDBCView.ACTION_PROFILE_CLASS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveJDBCView.this.profileClass(userValue);
                }
            });
        }
        if (this.profileMethodSupported() || this.profileClassSupported()) {
            popup.addSeparator();
        }
        if ((customItems = invoker.createCustomMenuItems(this, value, userValue)) != null) {
            for (JMenuItem customItem : customItems) {
                popup.add(customItem);
            }
            popup.addSeparator();
        }
        this.customizeNodePopup(invoker, popup, value, userValue);
        final ProfilerTreeTable ttable = (ProfilerTreeTable)this.jdbcCallsView.getResultsComponent();
        JMenu expand = new JMenu(JDBCView.EXPAND_MENU);
        popup.add(expand);
        expand.add(new JMenuItem(JDBCView.EXPAND_PLAIN_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ttable.expandPlainPath(ttable.getSelectedRow(), 1);
            }
        });
        expand.add(new JMenuItem(JDBCView.EXPAND_TOPMOST_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ttable.expandFirstPath(ttable.getSelectedRow());
            }
        });
        expand.addSeparator();
        expand.add(new JMenuItem(JDBCView.COLLAPSE_CHILDREN_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ttable.collapseChildren(ttable.getSelectedRow());
            }
        });
        expand.add(new JMenuItem(JDBCView.COLLAPSE_ALL_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ttable.collapseAll();
            }
        });
        popup.addSeparator();
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    protected void customizeNodePopup(DataView invoker, JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
    }

    private synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }
}

