/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class MethodNameTreeCellRenderer
extends EnhancedTreeCellRenderer {
    private Icon allThreadsIcon = Icons.getIcon((String)"ProfilerIcons.AllThreads");
    private Icon threadIcon = Icons.getIcon((String)"ProfilerIcons.Thread");

    @Override
    public Component getTreeCellRendererComponentPersistent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        MethodNameTreeCellRenderer renderer = new MethodNameTreeCellRenderer();
        renderer.setLeafIcon(this.getLeafIcon(value));
        renderer.setClosedIcon(this.getClosedIcon(value));
        renderer.setOpenIcon(this.getOpenIcon(value));
        Color backgroundColor = UIUtils.getProfilerResultsBackground();
        if ((row & 1) == 0) {
            renderer.setBackgroundNonSelectionColor(UIUtils.getDarker(backgroundColor));
        } else {
            renderer.setBackgroundNonSelectionColor(backgroundColor);
        }
        return renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    protected Icon getClosedIcon(Object value) {
        if (value instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode cct = (PrestimeCPUCCTNode)value;
            if (cct.isThreadNode()) {
                if (cct.getThreadId() == -1) {
                    return this.allThreadsIcon;
                }
                return this.threadIcon;
            }
            if (cct.isFiltered()) {
                return UIManager.getLookAndFeel().getDisabledIcon(this, super.getClosedIcon(value));
            }
        } else if (value instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)value).isFiltered()) {
            return UIManager.getLookAndFeel().getDisabledIcon(this, super.getClosedIcon(value));
        }
        return super.getClosedIcon(value);
    }

    @Override
    protected String getLabel1Text(Object node, String value) {
        if (node instanceof PrestimeCPUCCTNode ? ((PrestimeCPUCCTNode)node).isThreadNode() || ((PrestimeCPUCCTNode)node).isFiltered() : node instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)node).isFiltered()) {
            return "";
        }
        int bracketIndex = value.indexOf(40);
        int dotIndex = value.lastIndexOf(46);
        if (dotIndex == -1 && bracketIndex == -1) {
            return value;
        }
        if (bracketIndex != -1) {
            value = value.substring(0, bracketIndex);
            dotIndex = value.lastIndexOf(46);
        }
        return value.substring(0, dotIndex + 1);
    }

    @Override
    protected String getLabel2Text(Object node, String value) {
        if (node instanceof PrestimeCPUCCTNode) {
            if (((PrestimeCPUCCTNode)node).isThreadNode()) {
                return value;
            }
            if (((PrestimeCPUCCTNode)node).isFiltered()) {
                return "";
            }
        } else if (node instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)node).isFiltered()) {
            return "";
        }
        int bracketIndex = value.indexOf(40);
        int dotIndex = value.lastIndexOf(46);
        if (dotIndex == -1 && bracketIndex == -1) {
            return "";
        }
        if (bracketIndex != -1) {
            value = value.substring(0, bracketIndex);
            dotIndex = value.lastIndexOf(46);
        }
        return value.substring(dotIndex + 1);
    }

    @Override
    protected String getLabel3Text(Object node, String value) {
        int bracketIndex;
        if (node instanceof PrestimeCPUCCTNode) {
            if (((PrestimeCPUCCTNode)node).isThreadNode()) {
                return "";
            }
            if (((PrestimeCPUCCTNode)node).isFiltered()) {
                return value;
            }
        } else if (node instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)node).isFiltered()) {
            return value;
        }
        if ((bracketIndex = value.indexOf(40)) != -1) {
            return " " + value.substring(bracketIndex);
        }
        return "";
    }

    @Override
    protected Icon getLeafIcon(Object value) {
        if (value instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode cct = (PrestimeCPUCCTNode)value;
            if (cct.isThreadNode()) {
                if (cct.getThreadId() == -1) {
                    return this.allThreadsIcon;
                }
                return this.threadIcon;
            }
            if (cct.isFiltered()) {
                return UIManager.getLookAndFeel().getDisabledIcon(this, super.getLeafIcon(value));
            }
        } else if (value instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)value).isFiltered()) {
            return UIManager.getLookAndFeel().getDisabledIcon(this, super.getLeafIcon(value));
        }
        return super.getLeafIcon(value);
    }

    @Override
    protected Icon getOpenIcon(Object value) {
        if (value instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode cct = (PrestimeCPUCCTNode)value;
            if (cct.isThreadNode()) {
                if (cct.getThreadId() == -1) {
                    return this.allThreadsIcon;
                }
                return this.threadIcon;
            }
            if (cct.isFiltered()) {
                return UIManager.getLookAndFeel().getDisabledIcon(this, super.getOpenIcon(value));
            }
        } else if (value instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)value).isFiltered()) {
            return UIManager.getLookAndFeel().getDisabledIcon(this, super.getOpenIcon(value));
        }
        return super.getOpenIcon(value);
    }
}

