/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.processtreekiller;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.processtreekiller.DarwinCLibrary;
import org.netbeans.processtreekiller.DarwinSystem;
import org.netbeans.processtreekiller.EnvVars;
import org.netbeans.processtreekiller.UnixProcess;

class DarwinProcess
extends UnixProcess<DarwinProcess> {
    private final int pid;
    private final int ppid;
    private EnvVars envVars;
    private List<String> arguments;

    DarwinProcess(DarwinSystem system, int pid, int ppid) {
        super(system);
        this.pid = pid;
        this.ppid = ppid;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public DarwinProcess getParent() {
        return (DarwinProcess)this.system.get(this.ppid);
    }

    @Override
    public synchronized EnvVars getEnvVars() {
        if (this.envVars != null) {
            return this.envVars;
        }
        this.parse();
        return this.envVars;
    }

    @Override
    public List<String> getArguments() {
        if (this.arguments != null) {
            return this.arguments;
        }
        this.parse();
        return this.arguments;
    }

    private void parse() {
        try {
            this.arguments = new ArrayList<String>();
            this.envVars = new EnvVars();
            DarwinCLibrary.SizeT newLen = new DarwinCLibrary.SizeT();
            IntByReference argmaxRef = new IntByReference(0);
            DarwinCLibrary.SizeTByReference size = new DarwinCLibrary.SizeTByReference();
            size.setValue(4L);
            if (DarwinCLibrary.LIBC.sysctl(new int[]{1, 8}, 2, argmaxRef.getPointer(), size, null, newLen) != 0) {
                throw new IOException("Failed to get kernl.argmax: " + DarwinCLibrary.LIBC.strerror(Native.getLastError()));
            }
            int argmax = argmaxRef.getValue();
            class StringArrayMemory
            extends Memory {
                private long offset;

                StringArrayMemory(long l) {
                    super(l);
                    this.offset = 0L;
                }

                int readInt() {
                    int r = this.getInt(this.offset);
                    this.offset += 4L;
                    return r;
                }

                byte peek() {
                    return this.getByte(this.offset);
                }

                String readString() {
                    byte ch;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((ch = this.getByte(this.offset++)) != 0 && this.offset < this.size()) {
                        baos.write(ch);
                    }
                    return Native.toString((byte[])baos.toByteArray());
                }

                void skip0() {
                    while (this.getByte(this.offset) == 0 && this.offset < this.size()) {
                        ++this.offset;
                    }
                }
            }
            StringArrayMemory m = new StringArrayMemory(argmax);
            size.setValue(argmax);
            if (DarwinCLibrary.LIBC.sysctl(new int[]{1, 49, this.pid}, 3, (Pointer)m, size, null, newLen) != 0) {
                throw new IOException("Failed to obtain ken.procargs2: " + DarwinCLibrary.LIBC.strerror(Native.getLastError()));
            }
            int argc = m.readInt();
            String args0 = m.readString();
            m.skip0();
            try {
                for (int i = 0; i < argc; ++i) {
                    this.arguments.add(m.readString());
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalStateException("Failed to parse arguments: arg0=" + args0 + ", arguments=" + this.arguments + ", nargs=" + argc, e);
            }
            while (m.peek() != 0) {
                this.envVars.addLine(m.readString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

