/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;
import org.netbeans.lib.profiler.results.memory.SurvGenSet;

public class PresoObjLivenessCCTNode
extends PresoObjAllocCCTNode {
    static int currentEpoch;
    public static final int SORT_BY_LIVE_OBJ_SIZE = 1;
    public static final int SORT_BY_LIVE_OBJ_NUMBER = 2;
    public static final int SORT_BY_ALLOC_OBJ = 3;
    public static final int SORT_BY_AVG_AGE = 4;
    public static final int SORT_BY_SURV_GEN = 5;
    public static final int SORT_BY_NAME = 6;
    public static final int SORT_BY_TOTAL_ALLOC_OBJ = 7;
    private static boolean dontShowZeroLiveObjNodes;
    public float avgObjectAge;
    public int nLiveObjects;
    public int survGen;
    public int nTotalAllocObjects = -1;

    public static PresoObjLivenessCCTNode rootNode(PresoObjLivenessCCTNode[] children) {
        PresoObjLivenessCCTNode root = new PresoObjLivenessCCTNode();
        root.setChildren(children);
        return root;
    }

    public PresoObjLivenessCCTNode(String className, long nCalls, long totalObjSize, int nLiveObjects, int nTotalAllocObjects, float avgObjectAge, int survGen) {
        super(className, nCalls, totalObjSize);
        this.nLiveObjects = nLiveObjects;
        this.nTotalAllocObjects = nTotalAllocObjects;
        this.avgObjectAge = avgObjectAge;
        this.survGen = survGen;
    }

    PresoObjLivenessCCTNode() {
    }

    protected PresoObjLivenessCCTNode(RuntimeMemoryCCTNode rtNode) {
        super(rtNode);
    }

    @Override
    public PresoObjLivenessCCTNode createFilteredNode() {
        PresoObjLivenessCCTNode filtered = new PresoObjLivenessCCTNode();
        this.setupFilteredNode(filtered);
        return filtered;
    }

    protected void setupFilteredNode(PresoObjLivenessCCTNode filtered) {
        super.setupFilteredNode(filtered);
        filtered.nLiveObjects = this.nLiveObjects;
        filtered.avgObjectAge = this.avgObjectAge;
        filtered.survGen = this.survGen;
    }

    @Override
    public void merge(CCTNode node) {
        if (node instanceof PresoObjLivenessCCTNode) {
            PresoObjLivenessCCTNode _node = (PresoObjLivenessCCTNode)node;
            this.nLiveObjects += _node.nLiveObjects;
            this.avgObjectAge = Math.max(this.avgObjectAge, _node.avgObjectAge);
            this.survGen = Math.max(this.survGen, _node.survGen);
            super.merge(node);
        }
    }

    public static PresoObjLivenessCCTNode createPresentationCCTFromSnapshot(LivenessMemoryResultsSnapshot snapshot, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName, int curEpoch, boolean dontShowZeroLiveObjAllocPaths) {
        currentEpoch = curEpoch;
        dontShowZeroLiveObjNodes = dontShowZeroLiveObjAllocPaths;
        SurvGenSet survGens = new SurvGenSet();
        PresoObjLivenessCCTNode rootNode = PresoObjLivenessCCTNode.generateMirrorNode(rootRuntimeNode, survGens);
        if (rootNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromSnapshot(snapshot.getJMethodIdTable(), rootNode, classTypeName);
        }
        return rootNode;
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName, int curEpoch, boolean dontShowZeroLiveObjAllocPaths) throws ClientUtils.TargetAppOrVMTerminated {
        currentEpoch = curEpoch;
        dontShowZeroLiveObjNodes = dontShowZeroLiveObjAllocPaths;
        SurvGenSet survGens = new SurvGenSet();
        PresoObjLivenessCCTNode rootNode = PresoObjLivenessCCTNode.generateMirrorNode(rootRuntimeNode, survGens);
        if (rootNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromVM(profilerClient, rootNode, classTypeName);
        }
        return rootNode;
    }

    @Override
    public void sortChildren(int sortBy, boolean sortOrder) {
    }

    protected static PresoObjLivenessCCTNode generateMirrorNode(RuntimeMemoryCCTNode rtNode, SurvGenSet survGens) {
        RuntimeMemoryCCTNode[] ar;
        int nChildren;
        Object nodeChildren;
        PresoObjLivenessCCTNode thisNode = null;
        if (rtNode instanceof RuntimeObjLivenessTermCCTNode) {
            RuntimeObjLivenessTermCCTNode rtTermNode = (RuntimeObjLivenessTermCCTNode)rtNode;
            int nLiveObjects = rtTermNode.calculateTotalNLiveObjects();
            if (dontShowZeroLiveObjNodes && nLiveObjects == 0 && rtNode.children == null) {
                return null;
            }
            thisNode = new PresoObjLivenessCCTNode(rtNode);
            thisNode.nLiveObjects = nLiveObjects;
            RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens(rtTermNode, survGens);
            thisNode.survGen = survGens.getTotalNoOfAges();
            thisNode.avgObjectAge = RuntimeObjLivenessTermCCTNode.calculateAvgObjectAgeForAllPaths(rtTermNode, currentEpoch);
            if (rtNode.children != null) {
                int len = rtNode.children instanceof RuntimeMemoryCCTNode ? 1 : ((RuntimeMemoryCCTNode[])rtNode.children).length;
                thisNode.children = new PresoObjAllocCCTNode[len];
            }
        }
        if ((nodeChildren = rtNode.children) != null && (nChildren = (ar = nodeChildren instanceof RuntimeMemoryCCTNode ? new RuntimeMemoryCCTNode[]{(RuntimeMemoryCCTNode)nodeChildren} : (RuntimeMemoryCCTNode[])nodeChildren).length) > 0) {
            double avgAge = 0.0;
            int childIdx = 0;
            for (int i = 0; i < nChildren; ++i) {
                SurvGenSet subNodeSurvGens = nChildren == 1 ? survGens : new SurvGenSet();
                PresoObjLivenessCCTNode child = PresoObjLivenessCCTNode.generateMirrorNode(ar[i], subNodeSurvGens);
                if (child == null) continue;
                if (thisNode == null) {
                    thisNode = new PresoObjLivenessCCTNode(rtNode);
                    thisNode.children = new PresoObjAllocCCTNode[nChildren];
                }
                thisNode.children[childIdx++] = child;
                child.parent = thisNode;
                thisNode.nCalls += child.nCalls;
                thisNode.totalObjSize += child.totalObjSize;
                thisNode.nLiveObjects += child.nLiveObjects;
                avgAge += (double)(child.avgObjectAge * (float)child.nLiveObjects);
                if (nChildren <= 1) continue;
                survGens.mergeWith(subNodeSurvGens);
            }
            if (dontShowZeroLiveObjNodes && (thisNode == null || thisNode.nLiveObjects == 0)) {
                return null;
            }
            if (childIdx < nChildren) {
                PresoObjAllocCCTNode[] newChildren = new PresoObjAllocCCTNode[childIdx];
                System.arraycopy(thisNode.children, 0, newChildren, 0, childIdx);
                thisNode.children = newChildren;
            }
            thisNode.avgObjectAge = thisNode.nLiveObjects > 0 ? (float)(avgAge / (double)thisNode.nLiveObjects) : 0.0f;
            thisNode.survGen = survGens.getTotalNoOfAges();
        }
        return thisNode;
    }

    @Override
    public void exportXMLData(ExportDataDumper eDD, String indent) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(indent + "<Node>" + newline);
        result.append(indent).append(" <Name>").append(this.replaceHTMLCharacters(this.getNodeName())).append("</Name>").append(newline);
        result.append(indent).append(" <Parent>").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName())).append("</Parent>").append(newline);
        result.append(indent).append(" <Live_Bytes>").append(this.totalObjSize).append("</Live_Bytes>").append(newline);
        result.append(indent).append(" <Live_Objects>").append(this.nLiveObjects).append("</Live_Objects>").append(newline);
        result.append(indent).append(" <Allocated_Objects>").append(this.nCalls).append("</Allocated_Objects>").append(newline);
        result.append(indent).append(" <Avg_Age>").append(this.avgObjectAge).append("</Avg_Age>").append(newline);
        result.append(indent).append(" <Generations>").append(this.survGen).append("</Generations>").append(newline);
        eDD.dumpData(result);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                this.children[i].exportXMLData(eDD, indent + " ");
            }
        }
        result = new StringBuffer(indent + "</Node>");
        eDD.dumpData(result);
    }

    @Override
    public void exportHTMLData(ExportDataDumper eDD, int depth) {
        int i;
        StringBuffer result = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (i = 0; i < depth; ++i) {
            result.append(".");
        }
        result.append(this.replaceHTMLCharacters(this.getNodeName())).append("</pre></td><td class=\"right\">").append(this.totalObjSize).append("</td><td class=\"right\">").append(this.nLiveObjects).append("</td><td class=\"right\">").append(this.nCalls).append("</td><td class=\"right\">").append(this.avgObjectAge).append("</td><td class=\"right\">").append(this.survGen).append("</td><td class=\"parent\"><pre class=\"parent\">").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName())).append("</pre></td></tr>");
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.children.length; ++i) {
                this.children[i].exportHTMLData(eDD, depth + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void exportCSVData(String separator, int depth, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        String indent = " ";
        result.append(quote);
        for (i = 0; i < depth; ++i) {
            result.append(indent);
        }
        result.append(this.getNodeName()).append(quote).append(separator);
        result.append(quote).append(this.totalObjSize).append(quote).append(separator);
        result.append(quote).append(this.nLiveObjects).append(quote).append(separator);
        result.append(quote).append(this.nCalls).append(quote).append(separator);
        result.append(quote).append(this.survGen).append(quote).append(separator);
        result.append(quote).append(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()).append(newLine);
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.children.length; ++i) {
                ((PresoObjLivenessCCTNode)this.children[i]).exportCSVData(separator, depth + 1, eDD);
            }
        }
    }

    public void setDecimalFormat() {
    }
}

