/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.DiffObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class JdbcResultsDiff
extends JdbcResultsSnapshot {
    private final JdbcResultsSnapshot snapshot1;
    private final JdbcResultsSnapshot snapshot2;
    private Map selectIdToSnapshot1;
    private Map selectIdToSnapshot2;

    public JdbcResultsDiff(JdbcResultsSnapshot snapshot1, JdbcResultsSnapshot snapshot2) {
        this.snapshot1 = snapshot1;
        this.snapshot2 = snapshot2;
        this.computeDiff(snapshot1, snapshot2);
    }

    @Override
    public long getBeginTime() {
        return -1L;
    }

    @Override
    public JMethodIdTable getJMethodIdTable() {
        return null;
    }

    @Override
    public long getTimeTaken() {
        return -1L;
    }

    @Override
    public boolean containsStacks() {
        return this.snapshot1.containsStacks() && this.snapshot2.containsStacks();
    }

    @Override
    public PresoObjAllocCCTNode createPresentationCCT(int selectId, boolean dontShowZeroLiveObjAllocPaths) {
        int selectId1 = this.selectId1(selectId);
        int selectId2 = this.selectId2(selectId);
        PresoObjAllocCCTNode node1 = null;
        PresoObjAllocCCTNode node2 = null;
        if (selectId1 != -1) {
            node1 = this.snapshot1.createPresentationCCT(selectId1, dontShowZeroLiveObjAllocPaths);
        }
        if (selectId2 != -1) {
            node2 = this.snapshot2.createPresentationCCT(selectId2, dontShowZeroLiveObjAllocPaths);
        }
        return new DiffObjAllocCCTNode(node1, node2);
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        PresoObjAllocCCTNode node1 = this.snapshot1.createPresentationCCT(rootNode, this.selectId1(classId), dontShowZeroLiveObjAllocPaths);
        PresoObjAllocCCTNode node2 = this.snapshot2.createPresentationCCT(rootNode, this.selectId2(classId), dontShowZeroLiveObjAllocPaths);
        return new DiffObjAllocCCTNode(node1, node2);
    }

    private int selectId1(int selectId) {
        Integer id = (Integer)this.selectIdToSnapshot1.get(selectId);
        if (id != null) {
            return id;
        }
        return -1;
    }

    private int selectId2(int selectId) {
        Integer id = (Integer)this.selectIdToSnapshot2.get(selectId);
        if (id != null) {
            return id;
        }
        return -1;
    }

    private void computeDiff(JdbcResultsSnapshot snapshot1, JdbcResultsSnapshot snapshot2) {
        int s1nSelects = snapshot1.getNProfiledSelects();
        int s2nSelects = snapshot2.getNProfiledSelects();
        HashMap<String, Integer> selectsNamesIdxMap = new HashMap<String, Integer>(s1nSelects);
        ArrayList<String> selectsArr = new ArrayList<String>(s1nSelects);
        ArrayList<Long> invocationsArr = new ArrayList<Long>(s1nSelects);
        ArrayList<Long> timesArr = new ArrayList<Long>(s1nSelects);
        ArrayList<Integer> commandsArr = new ArrayList<Integer>(s1nSelects);
        ArrayList<String[]> tablesArr = new ArrayList<String[]>(s1nSelects);
        ArrayList<Integer> typesArr = new ArrayList<Integer>(s1nSelects);
        String[] s1SelectNames = snapshot1.getSelectNames();
        long[] s1Invocations = snapshot1.getInvocationsPerSelectId();
        long[] s1Times = snapshot1.getTimePerSelectId();
        int[] s1Types = snapshot1.getTypeForSelectId();
        int[] s1Commands = snapshot1.getCommandTypeForSelectId();
        String[][] s1Tables = snapshot1.getTablesForSelectId();
        this.selectIdToSnapshot1 = new HashMap(s1nSelects);
        for (int i = 0; i < s1nSelects; ++i) {
            String selectId = s1SelectNames[i] + Integer.toString(s1Types[i]);
            selectsNamesIdxMap.put(selectId, i);
            this.selectIdToSnapshot1.put(i, i);
            selectsArr.add(s1SelectNames[i]);
            invocationsArr.add(-s1Invocations[i]);
            timesArr.add(-s1Times[i]);
            commandsArr.add(s1Commands[i]);
            tablesArr.add(s1Tables[i]);
            typesArr.add(s1Types[i]);
        }
        String[] s2SelectNames = snapshot2.getSelectNames();
        long[] s2Invocations = snapshot2.getInvocationsPerSelectId();
        long[] s2Times = snapshot2.getTimePerSelectId();
        int[] s2Types = snapshot2.getTypeForSelectId();
        int[] s2Commands = snapshot2.getCommandTypeForSelectId();
        String[][] s2Tables = snapshot2.getTablesForSelectId();
        this.selectIdToSnapshot2 = new HashMap(s2nSelects);
        for (int i = 1; i < s2nSelects; ++i) {
            String selectId = s2SelectNames[i] + Integer.toString(s2Types[i]);
            Integer selectIdx = (Integer)selectsNamesIdxMap.get(selectId);
            if (selectIdx != null) {
                invocationsArr.set(selectIdx, -s1Invocations[selectIdx] + s2Invocations[i]);
                timesArr.set(selectIdx, -s1Times[selectIdx] + s2Times[i]);
                this.selectIdToSnapshot2.put(selectIdx, i);
                continue;
            }
            selectsNamesIdxMap.put(selectId, selectsArr.size());
            this.selectIdToSnapshot2.put(selectsArr.size(), i);
            selectsArr.add(s2SelectNames[i]);
            invocationsArr.add(s2Invocations[i]);
            timesArr.add(s2Times[i]);
            commandsArr.add(s2Commands[i]);
            tablesArr.add(s2Tables[i]);
            typesArr.add(s2Types[i]);
        }
        this.nProfiledSelects = selectsNamesIdxMap.size();
        this.selectNames = new String[this.nProfiledSelects];
        this.invocationsPerSelectId = new long[this.nProfiledSelects];
        this.timePerSelectId = new long[this.nProfiledSelects];
        this.commandTypeForSelectId = new int[this.nProfiledSelects];
        this.tablesForSelectId = new String[this.nProfiledSelects][];
        this.typeForSelectId = new int[this.nProfiledSelects];
        for (int index = 1; index < selectsArr.size(); ++index) {
            this.selectNames[index] = (String)selectsArr.get(index);
            this.invocationsPerSelectId[index] = (Long)invocationsArr.get(index);
            this.timePerSelectId[index] = (Long)timesArr.get(index);
            this.commandTypeForSelectId[index] = (Integer)commandsArr.get(index);
            this.tablesForSelectId[index] = (String[])tablesArr.get(index);
            this.typeForSelectId[index] = (Integer)typesArr.get(index);
        }
    }
}

