/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.repository.Bundle;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class OpenGlobalConfigurationAction
extends GitAction {
    private static final Logger LOG = Logger.getLogger(OpenGlobalConfigurationAction.class.getName());

    @Override
    protected boolean enableFull(Node[] activatedNodes) {
        return true;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                File config = SystemReader.getInstance().openUserConfig(null, FS.DETECTED).getFile();
                if (!config.exists()) {
                    if (OpenGlobalConfigurationAction.this.shallCreate(config)) {
                        try {
                            if (!config.createNewFile()) {
                                LOG.log(Level.WARNING, "Git config not created: {0}", new Object[]{config.getPath()});
                            }
                        }
                        catch (IOException ex) {
                            GitClientExceptionHandler.notifyException(ex, true);
                        }
                    } else {
                        return;
                    }
                }
                if (config.canRead()) {
                    Utils.openFile((File)config);
                } else {
                    LOG.log(Level.WARNING, "Cannot read Git config: {0}", new Object[]{config.getPath()});
                }
            }
        }, (int)0);
    }

    private boolean shallCreate(File configFile) {
        return NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_OpenGlobalConfigurationAction_CreateConfigFile(configFile.getAbsolutePath()), Bundle.LBL_OpenGlobalConfigurationAction_CreateConfigFile(), 0));
    }
}

