/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.conflicts;

import java.io.File;
import java.util.EnumSet;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsExecutor;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ResolveConflictsAction
extends MultipleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/conflict-resolve.png";

    public ResolveConflictsAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected boolean enableFull(Node[] activatedNodes) {
        VCSContext context = this.getCurrentContext(activatedNodes);
        return Git.getInstance().getFileStatusCache().containsFiles(context, EnumSet.of(FileInformation.Status.IN_CONFLICT), false);
    }

    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        File[] files = Git.getInstance().getFileStatusCache().listFiles(roots, EnumSet.of(FileInformation.Status.IN_CONFLICT));
        if (files.length > 0) {
            ResolveConflictsExecutor supp = new ResolveConflictsExecutor(files);
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_PreparingMerge"));
            return supp.getTask();
        }
        return null;
    }
}

