/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.logging;

import java.io.PrintStream;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.logging.TomcatLogger;

public class LogHelper {
    private String logname;
    private Object prepend;
    private Logger logger;

    public LogHelper(String logname, Object prepend) {
        this.logname = logname;
        this.prepend = prepend;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void log(String msg) {
        this.log(msg, null, 3);
    }

    public void log(String msg, Throwable t) {
        this.log(msg, t, 1);
    }

    public void log(String msg, Throwable t, int level) {
        if (this.prepend != null) {
            msg = this.prepend.toString() + ": " + msg;
        }
        if (this.logger == null && this.logname != null) {
            this.logger = Logger.getLogger(this.logname);
        }
        if (this.logger == null) {
            PrintStream out = level <= 2 ? System.err : System.out;
            out.println(msg);
            if (t != null) {
                out.print(TomcatLogger.throwableToString(t));
            }
        } else {
            this.logger.log(msg, t, level);
        }
    }
}

