/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.jumpto.common.AbstractModelFilter;
import org.netbeans.modules.jumpto.common.CurrentSearch;
import org.netbeans.modules.jumpto.common.ItemRenderer;
import org.netbeans.modules.jumpto.common.Models;
import org.netbeans.modules.jumpto.common.Utils;
import org.netbeans.modules.jumpto.file.FileComarator;
import org.netbeans.modules.jumpto.file.FileProviderAccessor;
import org.netbeans.modules.jumpto.file.FileSearchOptions;
import org.netbeans.modules.jumpto.file.FileSearchPanel;
import org.netbeans.modules.jumpto.file.Worker;
import org.netbeans.modules.jumpto.settings.GoToSettings;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class FileSearchAction
extends AbstractAction
implements FileSearchPanel.ContentProvider {
    static final Logger LOGGER = Logger.getLogger(FileSearchAction.class.getName());
    static final String CAMEL_CASE_SEPARATOR = "\\p{javaUpperCase}|-|_|\\.";
    static final String CAMEL_CASE_PART_CASE_SENSITIVE = "\\p{javaLowerCase}|\\p{Digit}|\\$";
    static final String CAMEL_CASE_PART_CASE_INSENSITIVE = "\\p{javaLowerCase}|\\p{Digit}|\\p{javaUpperCase}|\\$";
    static final Map<String, Object> SEARCH_OPTIONS_CASE_SENSITIVE;
    static final Map<String, Object> SEARCH_OPTIONS_CASE_INSENSITIVE;
    private static final char LINE_NUMBER_SEPARATOR = ':';
    private static final Pattern PATTERN_WITH_LINE_NUMBER;
    private static final ListModel EMPTY_LIST_MODEL;
    private static final RequestProcessor slidingRp;
    private static final RequestProcessor rp;
    private final FilterFactory filterFactory = new FilterFactory();
    private final CurrentSearch<FileDescriptor> currentSearch = new CurrentSearch<FileDescriptor>(this.filterFactory);
    private final RequestProcessor.Task slidingTask = slidingRp.create(this::invokeProviders);
    private FileComarator itemsComparator;
    private Worker[] running;
    private RequestProcessor.Task[] scheduledTasks;
    private Request slidingTaskData;
    private Dialog dialog;
    private JButton openBtn;
    private FileSearchPanel panel;
    private Dimension initialDimension;

    public FileSearchAction() {
        super(NbBundle.getMessage(FileSearchAction.class, (String)"CTL_FileSearchAction"));
        this.putValue("PopupMenuText", NbBundle.getBundle(FileSearchAction.class).getString("editor-popup-CTL_FileSearchAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    public boolean isEnabled() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        FileDescriptor[] typeDescriptors = this.getSelectedFiles();
        if (typeDescriptors != null) {
            JumpList.checkAddEntry();
            for (FileDescriptor td : typeDescriptors) {
                td.open();
            }
        }
    }

    @Override
    @NonNull
    public ListCellRenderer getListCellRenderer(@NonNull JList list, @NonNull Document nameDocument, @NonNull ButtonModel caseSensitive, @NonNull ButtonModel colorPrefered, @NonNull ButtonModel searchFolders) {
        Parameters.notNull((CharSequence)"list", (Object)list);
        Parameters.notNull((CharSequence)"nameDocument", (Object)nameDocument);
        Parameters.notNull((CharSequence)"caseSensitive", (Object)caseSensitive);
        return ItemRenderer.Builder.create(list, caseSensitive, new FileDescriptorConvertor(nameDocument)).setCamelCaseSeparator(CAMEL_CASE_SEPARATOR).setColorPreferedProject(colorPrefered).setSearchFolders(searchFolders).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setListModel(FileSearchPanel panel, String text) {
        this.enableOK(false);
        this.cancel();
        if (text == null) {
            panel.setModel(EMPTY_LIST_MODEL, true);
            this.currentSearch.resetFilter();
            return false;
        }
        boolean exact = text.endsWith(" ");
        if ((text = text.trim()).length() == 0 || !Utils.isValidInput(text)) {
            this.currentSearch.filter(SearchType.EXACT_NAME, text, Collections.singletonMap("_clear_content", Boolean.TRUE));
            panel.revalidateModel(true);
            return false;
        }
        Pair<String, Integer> nameLinePair = FileSearchAction.splitNameLine(text);
        text = (String)nameLinePair.first();
        int lineNr = (Integer)nameLinePair.second();
        QuerySupport.Kind nameKind = Utils.toQueryKind(Utils.getSearchType(text, exact, panel.isCaseSensitive(), CAMEL_CASE_SEPARATOR, CAMEL_CASE_PART_CASE_INSENSITIVE));
        if (nameKind == QuerySupport.Kind.REGEXP || nameKind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
            text = Utils.removeNonNeededWildCards(text);
        }
        FileSearchAction fileSearchAction = this;
        synchronized (fileSearchAction) {
            SearchType searchType = Utils.toSearchType(nameKind);
            if (this.currentSearch.isNarrowing(searchType, text, FileSearchAction.getSearchScope(panel), true)) {
                this.itemsComparator.setUsePreferred(panel.isPreferedProject());
                this.itemsComparator.setText(text);
                this.filterFactory.setLineNumber(lineNr);
                this.filterFactory.setSearchByFolders(panel.isSearchByFolders());
                this.currentSearch.filter(searchType, text, panel.isCaseSensitive() ? SEARCH_OPTIONS_CASE_SENSITIVE : SEARCH_OPTIONS_CASE_INSENSITIVE);
                this.enableOK(panel.searchCompleted(true));
                return false;
            }
            this.slidingTaskData = new Request(text, nameKind, searchType, lineNr);
            this.slidingTask.schedule(500);
            LOGGER.log(Level.FINE, "Scheduled for text: {0}", text);
            return true;
        }
    }

    @Override
    public void closeDialog() {
        this.cleanup(true);
    }

    @Override
    public boolean hasValidContent() {
        return this.openBtn != null && this.openBtn.isEnabled();
    }

    private synchronized void invokeProviders() {
        if (this.slidingTaskData == null) {
            return;
        }
        String searchText = this.slidingTaskData.text;
        LOGGER.log(Level.FINE, "Calling providers for text: {0}", searchText);
        this.itemsComparator = FileComarator.create(GoToSettings.getDefault().getSortingType(), searchText, this.panel.isPreferedProject(), this.panel.isCaseSensitive(), GoToSettings.getDefault().isSortingPreferOpenProjects());
        Models.MutableListModel<FileDescriptor> baseListModel = Models.mutable(this.itemsComparator, this.currentSearch.resetFilter(), null);
        this.panel.setModel(Models.refreshable(baseListModel, param -> new AsyncFileDescriptor((FileDescriptor)param.first(), (Runnable)param.second())), false);
        Worker.Request request = Worker.newRequest(searchText, this.slidingTaskData.kind, this.panel.getCurrentProject(), this.panel.isSearchByFolders(), this.slidingTaskData.lineNo);
        Worker.Collector collector = Worker.newCollector(baseListModel, () -> SwingUtilities.invokeLater(() -> {
            this.panel.searchProgress();
            this.enableOK(baseListModel.getSize() > 0);
        }), () -> {
            this.currentSearch.searchCompleted(this.slidingTaskData.type, searchText, FileSearchAction.getSearchScope(this.panel));
            SwingUtilities.invokeLater(() -> this.panel.searchCompleted(true));
        }, this.panel.time);
        Worker.Type[] wts = Worker.Type.values();
        Worker[] workers = new Worker[wts.length];
        for (int i = 0; i < wts.length; ++i) {
            workers[i] = Worker.newWorker(request, collector, wts[i]);
        }
        this.running = workers;
        RequestProcessor.Task[] tasks = new RequestProcessor.Task[workers.length];
        for (int i = 0; i < workers.length; ++i) {
            tasks[i] = rp.post((Runnable)workers[i]);
        }
        this.scheduledTasks = tasks;
        if (this.panel.time != -1L) {
            LOGGER.log(Level.FINE, "Worker posted after {0} ms.", System.currentTimeMillis() - this.panel.time);
        }
    }

    private static String getSearchScope(FileSearchPanel panel) {
        return panel.isSearchByFolders() ? "folders-scope" : null;
    }

    private void enableOK(boolean enable) {
        if (this.openBtn != null) {
            this.openBtn.setEnabled(enable);
        }
    }

    private FileDescriptor[] getSelectedFiles() {
        JEditorPane recentPane;
        EditorCookie ec;
        FileDescriptor[] result = null;
        this.panel = new FileSearchPanel(this, FileSearchAction.findCurrentProject());
        this.dialog = this.createDialog(this.panel);
        Node[] arr = TopComponent.getRegistry().getActivatedNodes();
        if (arr.length > 0 && (ec = (EditorCookie)arr[0].getCookie(EditorCookie.class)) != null && (recentPane = NbDocument.findRecentEditorPane((EditorCookie)ec)) != null) {
            String initSearchText = null;
            if (Utilities.isSelectionShowing((Caret)recentPane.getCaret())) {
                initSearchText = recentPane.getSelectedText();
            }
            if (initSearchText != null) {
                if (initSearchText.length() > 256) {
                    initSearchText = initSearchText.substring(0, 256);
                }
                this.panel.setInitialText(initSearchText);
            } else {
                FileObject fo = (FileObject)arr[0].getLookup().lookup(FileObject.class);
                if (fo != null) {
                    this.panel.setInitialText(fo.getNameExt());
                }
            }
        }
        this.dialog.setVisible(true);
        result = this.panel.getSelectedFiles();
        return result;
    }

    private Dialog createDialog(FileSearchPanel panel) {
        this.openBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.openBtn, (String)NbBundle.getMessage(FileSearchAction.class, (String)"CTL_Open"));
        this.openBtn.getAccessibleContext().setAccessibleDescription(this.openBtn.getText());
        this.openBtn.setEnabled(false);
        Object[] buttons = new Object[]{this.openBtn, DialogDescriptor.CANCEL_OPTION};
        String title = NbBundle.getMessage(FileSearchAction.class, (String)"MSG_FileSearchDlgTitle");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, title, true, buttons, (Object)this.openBtn, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(panel));
        dialogDescriptor.setClosingOptions(buttons);
        Dialog d = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        d.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileSearchAction.class, (String)"AN_FileSearchDialog"));
        d.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchAction.class, (String)"AD_FileSearchDialog"));
        d.setPreferredSize(new Dimension(FileSearchOptions.getWidth(), FileSearchOptions.getHeight()));
        Rectangle r = org.openide.util.Utilities.getUsableScreenBounds();
        int maxW = r.width * 9 / 10;
        int maxH = r.height * 9 / 10;
        Dimension dim = d.getPreferredSize();
        dim.width = Math.min(dim.width, maxW);
        dim.height = Math.min(dim.height, maxH);
        this.initialDimension = dim;
        d.setBounds(org.openide.util.Utilities.findCenterBounds((Dimension)dim));
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                FileSearchAction.this.cleanup(false);
            }
        });
        return d;
    }

    private static Project findCurrentProject() {
        Lookup lookup = org.openide.util.Utilities.actionsGlobalContext();
        Iterator iterator = lookup.lookupAll(Project.class).iterator();
        if (iterator.hasNext()) {
            Project p = (Project)iterator.next();
            return p;
        }
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            return p;
        }
        return OpenProjects.getDefault().getMainProject();
    }

    private void cleanup(boolean hide) {
        this.cancel();
        if (this.dialog != null) {
            if (hide) {
                this.dialog.setVisible(false);
            }
            int currentWidth = this.dialog.getWidth();
            int currentHeight = this.dialog.getHeight();
            if (this.initialDimension != null && (this.initialDimension.width != currentWidth || this.initialDimension.height != currentHeight)) {
                FileSearchOptions.setHeight(currentHeight);
                FileSearchOptions.setWidth(currentWidth);
            }
            this.initialDimension = null;
            this.dialog.dispose();
            this.dialog = null;
            FileSearchOptions.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        this.slidingTask.cancel();
        FileSearchAction fileSearchAction = this;
        synchronized (fileSearchAction) {
            if (this.running != null) {
                for (Worker worker : this.running) {
                    worker.cancel();
                }
                for (Worker worker : this.scheduledTasks) {
                    worker.cancel();
                }
                this.running = null;
                this.scheduledTasks = null;
                this.panel.searchCompleted(false);
            }
        }
    }

    @NonNull
    private static Pair<String, Integer> splitNameLine(@NonNull String text) {
        Matcher matcher = PATTERN_WITH_LINE_NUMBER.matcher(text);
        int lineNr = -1;
        if (matcher.matches()) {
            text = matcher.group(1);
            try {
                lineNr = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Pair.of((Object)text, (Object)lineNr);
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("camelCaseSeparator", CAMEL_CASE_SEPARATOR);
        m.put("camelCasePart", CAMEL_CASE_PART_CASE_SENSITIVE);
        SEARCH_OPTIONS_CASE_SENSITIVE = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put("camelCaseSeparator", CAMEL_CASE_SEPARATOR);
        m.put("camelCasePart", CAMEL_CASE_PART_CASE_INSENSITIVE);
        SEARCH_OPTIONS_CASE_INSENSITIVE = Collections.unmodifiableMap(m);
        PATTERN_WITH_LINE_NUMBER = Pattern.compile("(.*):(\\d*)");
        EMPTY_LIST_MODEL = new DefaultListModel();
        slidingRp = new RequestProcessor("FileSearchAction-sliding", 1);
        rp = new RequestProcessor("FileSearchAction-worker", 1);
    }

    private static final class FilterFactory
    implements Callable<Models.Filter<FileDescriptor>> {
        private int currentLineNo;
        private boolean searchByFolders = false;

        private FilterFactory() {
        }

        void setSearchByFolders(boolean searchByFolders) {
            this.searchByFolders = searchByFolders;
        }

        void setLineNumber(int lineNo) {
            this.currentLineNo = lineNo;
        }

        @Override
        public Models.Filter<FileDescriptor> call() throws Exception {
            return new AbstractModelFilter<FileDescriptor>(){

                @Override
                @NonNull
                protected String getItemValue(@NonNull FileDescriptor item) {
                    return searchByFolders ? item.getOwnerPath() : item.getFileName();
                }

                @Override
                protected void update(@NonNull FileDescriptor item) {
                    FileProviderAccessor.getInstance().setLineNumber(item, currentLineNo);
                }
            };
        }
    }

    private static final class FileDescriptorConvertor
    implements ItemRenderer.Convertor<FileDescriptor>,
    DocumentListener {
        private String textToFind = "";

        FileDescriptorConvertor(@NonNull Document doc) {
            doc.addDocumentListener(this);
        }

        @Override
        public String getName(@NonNull FileDescriptor item) {
            return item.getFileName();
        }

        @Override
        public String getHighlightText(@NonNull FileDescriptor item) {
            return this.textToFind;
        }

        @Override
        public String getOwnerName(@NonNull FileDescriptor item) {
            return item.getOwnerPath().length() > 0 ? " (" + item.getOwnerPath() + ")" : "";
        }

        @Override
        public String getProjectName(@NonNull FileDescriptor item) {
            return item.getProjectName();
        }

        @Override
        public String getFilePath(@NonNull FileDescriptor item) {
            return item.getFileDisplayPath();
        }

        @Override
        public Icon getItemIcon(@NonNull FileDescriptor item) {
            return item.getIcon();
        }

        @Override
        public Icon getProjectIcon(@NonNull FileDescriptor item) {
            return item.getProjectIcon();
        }

        @Override
        public boolean isFromCurrentProject(@NonNull FileDescriptor item) {
            return FileProviderAccessor.getInstance().isFromCurrentProject(item);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            try {
                this.textToFind = (String)FileSearchAction.splitNameLine(e.getDocument().getText(0, e.getDocument().getLength())).first();
            }
            catch (BadLocationException ex) {
                this.textToFind = "";
            }
        }
    }

    private static final class AsyncFileDescriptor
    extends FileDescriptor
    implements Runnable {
        private static final String UNKNOWN_ICON_PATH = "org/netbeans/modules/jumpto/resources/unknown.gif";
        private static final Icon UNKNOWN_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jumpto/resources/unknown.gif", (boolean)false);
        private static final RequestProcessor LOAD_ICON_RP = new RequestProcessor(AsyncFileDescriptor.class.getName(), 1, false, false);
        private final FileDescriptor delegate;
        private final Runnable refreshCallback;
        private volatile Icon icon;

        AsyncFileDescriptor(@NonNull FileDescriptor delegate, @NonNull Runnable refreshCallback) {
            Parameters.notNull((CharSequence)"delegate", (Object)delegate);
            Parameters.notNull((CharSequence)"refreshCallback", (Object)refreshCallback);
            this.delegate = delegate;
            this.refreshCallback = refreshCallback;
            FileProviderAccessor.getInstance().setFromCurrentProject(this, FileProviderAccessor.getInstance().isFromCurrentProject(delegate));
        }

        @Override
        public String getFileName() {
            return this.delegate.getFileName();
        }

        @Override
        public String getOwnerPath() {
            return this.delegate.getOwnerPath();
        }

        @Override
        public Icon getIcon() {
            if (this.icon != null) {
                return this.icon;
            }
            LOAD_ICON_RP.execute((Runnable)this);
            return UNKNOWN_ICON;
        }

        @Override
        public String getProjectName() {
            return this.delegate.getProjectName();
        }

        @Override
        public Icon getProjectIcon() {
            return this.delegate.getProjectIcon();
        }

        @Override
        public void open() {
            this.delegate.open();
        }

        @Override
        public FileObject getFileObject() {
            FileObject res = this.delegate.getFileObject();
            if (res == null) {
                LOGGER.log(Level.FINE, "FileDescriptor: {0} : {1} returned null from getFile", new Object[]{this.delegate, this.delegate.getClass()});
            }
            return res;
        }

        @Override
        public String getFileDisplayPath() {
            return this.delegate.getFileDisplayPath();
        }

        @Override
        public void run() {
            this.icon = this.delegate.getIcon();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    refreshCallback.run();
                }
            });
        }
    }

    private static final class Request {
        final String text;
        final QuerySupport.Kind kind;
        final SearchType type;
        final int lineNo;

        Request(@NonNull String text, @NonNull QuerySupport.Kind kind, @NonNull SearchType type, int lineNo) {
            this.text = text;
            this.kind = kind;
            this.type = type;
            this.lineNo = lineNo;
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private FileSearchPanel panel;

        public DialogButtonListener(FileSearchPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FileSearchAction.this.openBtn) {
                this.panel.setSelectedFile();
            }
        }
    }
}

