/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.windows.ExternalDropHandler;

public class CssExternalDropHandler
extends ExternalDropHandler {
    private static final Logger LOG = Logger.getLogger(CssExternalDropHandler.class.getName());
    private static DataFlavor uriListDataFlavor;

    private boolean containsLanguageAtOffset(final Document document, final int offset) {
        if (offset == -1) {
            return false;
        }
        final AtomicBoolean result = new AtomicBoolean();
        document.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence leaf;
                TokenHierarchy th = TokenHierarchy.get((Document)document);
                List embeddedTokenSequences = th.embeddedTokenSequences(offset, true);
                if (!embeddedTokenSequences.isEmpty() && (leaf = (TokenSequence)embeddedTokenSequences.get(embeddedTokenSequences.size() - 1)).language() == CssTokenId.language()) {
                    result.set(true);
                }
                if (!(embeddedTokenSequences = th.embeddedTokenSequences(offset, false)).isEmpty() && (leaf = (TokenSequence)embeddedTokenSequences.get(embeddedTokenSequences.size() - 1)).language() == CssTokenId.language()) {
                    result.set(true);
                }
            }
        });
        return result.get();
    }

    private int getLineEndOffset(JEditorPane pane, Point location) {
        int offset = pane.getUI().viewToModel(pane, location);
        try {
            return org.netbeans.editor.Utilities.getRowEnd((BaseDocument)((BaseDocument)pane.getDocument()), (int)offset);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return offset;
        }
    }

    public boolean canDrop(DropTargetDragEvent e) {
        JEditorPane pane = this.findPane(e.getDropTargetContext().getComponent());
        if (pane == null) {
            return false;
        }
        int offset = this.getLineEndOffset(pane, e.getLocation());
        if (!this.containsLanguageAtOffset(pane.getDocument(), offset)) {
            return false;
        }
        pane.setCaretPosition(offset);
        pane.requestFocusInWindow();
        return this.canDrop(e.getCurrentDataFlavors());
    }

    public boolean canDrop(DropTargetDropEvent e) {
        JEditorPane pane = this.findPane(e.getDropTargetContext().getComponent());
        if (pane == null) {
            return false;
        }
        int offset = this.getLineEndOffset(pane, e.getLocation());
        if (!this.containsLanguageAtOffset(pane.getDocument(), offset)) {
            return false;
        }
        return this.canDrop(e.getCurrentDataFlavors());
    }

    private boolean canDrop(DataFlavor[] flavors) {
        for (int i = 0; null != flavors && i < flavors.length; ++i) {
            if (!DataFlavor.javaFileListFlavor.equals(flavors[i]) && !this.getUriListDataFlavor().equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleDrop(DropTargetDropEvent e) {
        String mimeType;
        Transferable t = e.getTransferable();
        if (null == t) {
            return false;
        }
        List<File> fileList = this.getFileList(t);
        if (fileList == null || fileList.isEmpty()) {
            return false;
        }
        File file = fileList.get(0);
        FileObject target = FileUtil.toFileObject((File)file);
        if (file.isDirectory()) {
            return true;
        }
        JEditorPane pane = this.findPane(e.getDropTargetContext().getComponent());
        if (pane == null) {
            return false;
        }
        final BaseDocument document = (BaseDocument)pane.getDocument();
        FileObject current = DataLoadersBridge.getDefault().getFileObject((Document)document);
        String relativePath = WebUtils.getRelativePath((FileObject)current, (FileObject)target);
        final StringBuilder sb = new StringBuilder();
        switch (mimeType = target.getMIMEType()) {
            case "text/css": 
            case "text/less": 
            case "text/scss": {
                sb.append("@import \"").append(relativePath).append("\";");
                break;
            }
            default: {
                LOG.log(Level.INFO, "Dropping of files with mimetype {0} is not supported -  what would you like to generate? Let me know in the issue 219985 please. Thank you!", mimeType);
                return true;
            }
        }
        final int offset = this.getLineEndOffset(pane, e.getLocation());
        final Indent indent = Indent.get((Document)document);
        indent.lock();
        try {
            document.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        int ofs = offset;
                        if (!org.netbeans.editor.Utilities.isRowWhite((BaseDocument)document, (int)ofs)) {
                            document.insertString(ofs, "\n", null);
                            ++ofs;
                        }
                        document.insertString(ofs, sb.toString(), null);
                        int from = org.netbeans.editor.Utilities.getRowStart((BaseDocument)document, (int)ofs);
                        int to = org.netbeans.editor.Utilities.getRowEnd((BaseDocument)document, (int)ofs);
                        indent.reindent(from, to);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
        return true;
    }

    private JEditorPane findPane(Component component) {
        while (component != null) {
            if (component instanceof JEditorPane) {
                return (JEditorPane)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private List<File> getFileList(Transferable t) {
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (InvalidDnDOperationException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            }
            if (t.isDataFlavorSupported(this.getUriListDataFlavor())) {
                String uriList = (String)t.getTransferData(this.getUriListDataFlavor());
                return this.textURIListToFileList(uriList);
            }
        }
        catch (UnsupportedFlavorException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        return null;
    }

    private DataFlavor getUriListDataFlavor() {
        if (null == uriListDataFlavor) {
            try {
                uriListDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException cnfE) {
                throw new AssertionError((Object)cnfE);
            }
        }
        return uriListDataFlavor;
    }

    private List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n\u0000");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = Utilities.toFile((URI)uri);
                list.add(file);
            }
            catch (IllegalArgumentException | URISyntaxException exception) {}
        }
        return list;
    }
}

