/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.JmsPropertyPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.PropertiesTable;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.PropertiesTableModel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.setFocus;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JmsPropertyVisualPanel
extends JPanel
implements WizardConstants,
TableModelListener {
    private final JmsPropertyPanel panel;
    private ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Bundle");
    private FieldGroup generalGroup;
    private FieldGroup propertiesGroup;
    private FieldGroup propertiesGroup2;
    private PropertiesTableModel tableModel;
    private TableColumn propNameColumn;
    private TableColumn propValueColumn;
    private ResourceConfigHelper helper;
    private JButton addButton;
    private JPanel buttonsPane;
    private JTextArea descriptionTextArea;
    private JScrollPane jScrollPane1;
    private JLabel propertyInfo;
    private JTable propertyTable;
    private JButton removeButton;

    public JmsPropertyVisualPanel(JmsPropertyPanel panel) {
        this.panel = panel;
        this.helper = panel.getHelper();
        this.generalGroup = panel.getFieldGroup("general");
        this.propertiesGroup = panel.getFieldGroup("properties");
        this.propertiesGroup2 = panel.getFieldGroup("properties2");
        this.tableModel = new PropertiesTableModel(this.helper.getData());
        this.initComponents();
        this.propNameColumn = this.propertyTable.getColumnModel().getColumn(0);
        this.setPropTableCellEditor();
        this.tableModel.addTableModelListener(this);
        this.propertyTable.setSelectionMode(0);
        this.propertyTable.setRowSelectionAllowed(true);
        this.setName(NbBundle.getMessage(JmsPropertyVisualPanel.class, (String)"TITLE_JMSPropertyPanel"));
    }

    private void initComponents() {
        this.descriptionTextArea = new JTextArea();
        this.propertyInfo = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.propertyTable = new PropertiesTable();
        this.buttonsPane = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setMinimumSize(new Dimension(627, 305));
        this.setPreferredSize(new Dimension(627, 305));
        this.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(NbBundle.getMessage(JmsPropertyVisualPanel.class, (String)"JMSPropertyPanel_Description", (Object)this.helper.getData().getString("res-type")));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setFocusable(false);
        this.descriptionTextArea.setMinimumSize(new Dimension(500, 17));
        this.descriptionTextArea.setOpaque(false);
        this.descriptionTextArea.setPreferredSize(new Dimension(500, 17));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle");
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(bundle.getString("JMSPropertyPanel_Description"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JmsPropertyVisualPanel.class, (String)"JMSPropertyPanel_Description", (Object)this.helper.getData().getString("res-type")));
        this.propertyInfo.setLabelFor(this.propertyTable);
        Mnemonics.setLocalizedText((JLabel)this.propertyInfo, (String)bundle.getString("LBL_properties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.add((Component)this.propertyInfo, gridBagConstraints);
        this.propertyInfo.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_propTableJMS_A11yDesc"));
        this.jScrollPane1.setPreferredSize(new Dimension(453, 17));
        this.propertyTable.setModel(this.tableModel);
        this.jScrollPane1.setViewportView(this.propertyTable);
        this.propertyTable.getAccessibleContext().setAccessibleName(bundle.getString("LBL_AddProperty"));
        this.propertyTable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_propTableJMS_A11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 12, 10, 11);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(bundle.getString("LBL_AddProperty"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_propTableJMS_A11yDesc"));
        this.buttonsPane.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)bundle.getString("LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsPropertyVisualPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 12, 12);
        this.buttonsPane.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_AddButtonA11yDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)bundle.getString("LBL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsPropertyVisualPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.buttonsPane.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_RemoveButtonA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipady = 150;
        this.add((Component)this.buttonsPane, gridBagConstraints);
        this.buttonsPane.getAccessibleContext().setAccessibleName(bundle.getString("LBL_AddProperty"));
        this.buttonsPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_propTableJMS_A11yDesc"));
        this.getAccessibleContext().setAccessibleName(bundle.getString("TITLE_JMSPropertyPanel"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("JMSPropertyPanel_Description"));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.propertyTable.editingStopped(new ChangeEvent(this));
        ResourceConfigData data = this.helper.getData();
        data.addProperty(new NameValuePair());
        this.tableModel.fireTableDataChanged();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.propertyTable.getSelectedRow();
        if (selectedRow != -1) {
            this.propertyTable.editingStopped(new ChangeEvent(this));
            this.helper.getData().removeProperty(selectedRow);
            this.tableModel.fireTableDataChanged();
        }
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        this.setPropTableCellEditor();
        this.panel.fireChange(evt.getSource());
    }

    public void setPropTableCellEditor() {
        JComboBox<String> propNameComboBox = new JComboBox<String>();
        String resType = this.helper.getData().getString("res-type");
        String[] remainingProperties = null;
        remainingProperties = resType.equals("javax.jms.Queue") || resType.equals("javax.jms.Topic") ? FieldHelper.getRemainingFieldNames(this.propertiesGroup, this.helper.getData().getPropertyNames()) : FieldHelper.getRemainingFieldNames(this.propertiesGroup2, this.helper.getData().getPropertyNames());
        for (int i = 0; i < remainingProperties.length; ++i) {
            propNameComboBox.addItem(remainingProperties[i]);
        }
        propNameComboBox.setEditable(true);
        this.propNameColumn = this.propertyTable.getColumnModel().getColumn(0);
        this.propNameColumn.setCellEditor(new DefaultCellEditor(propNameComboBox));
        this.propValueColumn = this.propertyTable.getColumnModel().getColumn(1);
        DefaultCellEditor editor = new DefaultCellEditor(new JTextField());
        editor.setClickCountToStart(1);
        this.propValueColumn.setCellEditor(editor);
    }

    public void refreshFields() {
        ResourceConfigData data = this.helper.getData();
        ((PropertiesTableModel)this.propertyTable.getModel()).setData(this.helper.getData());
        this.descriptionTextArea.setText(NbBundle.getMessage(JmsPropertyVisualPanel.class, (String)"JMSPropertyPanel_Description", (Object)data.getString("res-type")));
    }

    public void setInitialFocus() {
        new setFocus(this.addButton);
    }
}

