/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.testng.AbstractTestGenerator;
import org.netbeans.modules.testng.TestGenerator;
import org.netbeans.modules.testng.TestGeneratorSetup;
import org.netbeans.modules.testng.TestabilityJudge;
import org.netbeans.modules.testng.TestabilityResult;
import org.openide.filesystems.FileObject;

public final class TestCreator
implements TestabilityJudge {
    static final Set<Modifier> ACCESS_MODIFIERS = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
    private final TestGeneratorSetup setup;

    TestCreator(boolean loadDefaults) {
        this.setup = new TestGeneratorSetup(loadDefaults);
    }

    TestCreator(Map<CommonPlugin.CreateTestParam, Object> params) {
        this.setup = new TestGeneratorSetup(params);
    }

    public void createEmptyTest(FileObject testFileObj) throws IOException {
        TestGenerator testGenerator = new TestGenerator(this.setup);
        this.doModifications(testFileObj, testGenerator);
    }

    public void createSimpleTest(ElementHandle<TypeElement> topClassToTest, FileObject testFileObj, boolean isNewTestClass) throws IOException {
        TestGenerator testGenerator = new TestGenerator(this.setup, Collections.singletonList(topClassToTest), null, isNewTestClass);
        this.doModifications(testFileObj, testGenerator);
    }

    public List<String> createTestSuite(List<String> suiteMembers, FileObject testFileObj, boolean isNewTestClass) throws IOException {
        TestGenerator testGenerator = new TestGenerator(this.setup, null, suiteMembers, isNewTestClass);
        this.doModifications(testFileObj, testGenerator);
        return testGenerator.getProcessedClassNames();
    }

    private void doModifications(FileObject testFileObj, final AbstractTestGenerator testGenerator) throws IOException {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)testFileObj);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController parameter) throws Exception {
                ModificationResult result = javaSource.runModificationTask((Task)testGenerator);
                result.commit();
            }
        }, true);
    }

    @Override
    public TestabilityResult isClassTestable(CompilationInfo compInfo, TypeElement classElem, long skipTestabilityResultMask) {
        return this.setup.isClassTestable(compInfo, classElem, skipTestabilityResultMask);
    }

    @Override
    public boolean isMethodTestable(ExecutableElement method) {
        return this.setup.isMethodTestable(method);
    }
}

