/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly;

import java.util.Locale;
import java.util.Vector;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;

public class WildflyTargetModuleID
implements TargetModuleID {
    private Target target;
    private String jar_name;
    private String context_url;
    private J2eeModule.Type type;
    private boolean exploded = false;
    private Vector childs = new Vector();
    private TargetModuleID parent = null;

    public WildflyTargetModuleID(Target target, String moduleName, J2eeModule.Type type, boolean exploded) {
        this.target = target;
        this.type = type;
        this.exploded = exploded;
        this.jar_name = this.computeArchiveName(moduleName);
        if (type == J2eeModule.Type.WAR) {
            this.context_url = '/' + this.jar_name.substring(0, this.jar_name.length() - 4);
        }
    }

    public J2eeModule.Type getType() {
        return this.type;
    }

    private final String computeArchiveName(String moduleName) {
        if (J2eeModule.Type.WAR.equals(this.type)) {
            if (!this.checkExtension(moduleName, ".war")) {
                return moduleName + ".war";
            }
            return moduleName;
        }
        if (J2eeModule.Type.EAR.equals(this.type)) {
            if (!this.checkExtension(moduleName, ".ear")) {
                return moduleName + ".ear";
            }
            return moduleName;
        }
        if (J2eeModule.Type.EJB.equals(this.type)) {
            if (!this.checkExtension(moduleName, ".jar")) {
                return moduleName + ".jar";
            }
            return moduleName;
        }
        if (J2eeModule.Type.RAR.equals(this.type)) {
            if (!this.checkExtension(moduleName, ".rar")) {
                return moduleName + ".rar";
            }
            return moduleName;
        }
        if (J2eeModule.Type.CAR.equals(this.type) && !this.checkExtension(moduleName, ".car")) {
            return moduleName + ".car";
        }
        return moduleName;
    }

    private boolean checkExtension(String name, String extension) {
        return name.toLowerCase(Locale.getDefault()).endsWith(extension);
    }

    public void setContextURL(String context_url) {
        this.context_url = context_url;
    }

    public void setJARName(String jar_name) {
        this.jar_name = this.computeArchiveName(jar_name);
    }

    public void setParent(WildflyTargetModuleID parent) {
        this.parent = parent;
    }

    public void addChild(WildflyTargetModuleID child) {
        this.childs.add(child);
        child.setParent(this);
    }

    public TargetModuleID[] getChildTargetModuleID() {
        return this.childs.toArray(new TargetModuleID[this.childs.size()]);
    }

    public String getModuleID() {
        return this.jar_name;
    }

    public TargetModuleID getParentTargetModuleID() {
        return this.parent;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getWebURL() {
        return this.context_url;
    }

    public String toString() {
        return this.getModuleID();
    }

    public boolean isExploded() {
        return this.exploded;
    }
}

