/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakSet;

public class IncludePathClassPathProvider
implements ClassPathProvider {
    private static final boolean RUNNING_IN_TEST = Boolean.getBoolean("nb.php.test.run");
    private static final Set<ClassPath> PROJECT_INCLUDES = new WeakSet();
    private static final ReadWriteLock PROJECT_INCLUDES_LOCK = new ReentrantReadWriteLock();
    static ClassPath globalIncludePathClassPath = null;
    private static PropertyChangeListener includePathListener = null;

    public static void addProjectIncludePath(final ClassPath classPath) {
        IncludePathClassPathProvider.runUnderWriteLock(new Runnable(){

            @Override
            public void run() {
                PROJECT_INCLUDES.add(classPath);
            }
        });
    }

    public static void removeProjectIncludePath(final ClassPath classPath) {
        IncludePathClassPathProvider.runUnderWriteLock(new Runnable(){

            @Override
            public void run() {
                PROJECT_INCLUDES.remove(classPath);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassPath findProjectIncludePath(FileObject file) {
        PROJECT_INCLUDES_LOCK.readLock().lock();
        try {
            for (ClassPath classPath : PROJECT_INCLUDES) {
                if (!classPath.contains(file)) continue;
                ClassPath classPath2 = classPath;
                return classPath2;
            }
        }
        finally {
            PROJECT_INCLUDES_LOCK.readLock().unlock();
        }
        return null;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (!"classpath/php-boot".equals(type)) {
            return null;
        }
        ClassPath cp = IncludePathClassPathProvider.findProjectIncludePath(file);
        if (cp != null) {
            return cp;
        }
        if (RUNNING_IN_TEST) {
            return null;
        }
        return IncludePathClassPathProvider.getGlobalIncludePathClassPath();
    }

    private static synchronized ClassPath getGlobalIncludePathClassPath() {
        if (includePathListener == null) {
            includePathListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("propPhpGlobalIncludePath".equals(evt.getPropertyName())) {
                        IncludePathClassPathProvider.resetGlobalIncludePathClassPath();
                    }
                }
            };
            PhpOptions.getInstance().addPropertyChangeListener(includePathListener);
        }
        if (globalIncludePathClassPath == null) {
            List<FileObject> includePath = PhpSourcePath.getIncludePath(null);
            globalIncludePathClassPath = ClassPathSupport.createClassPath((FileObject[])includePath.toArray(new FileObject[includePath.size()]));
        }
        return globalIncludePathClassPath;
    }

    static synchronized void resetGlobalIncludePathClassPath() {
        globalIncludePathClassPath = null;
    }

    private static void runUnderWriteLock(Runnable runnable) {
        PROJECT_INCLUDES_LOCK.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            PROJECT_INCLUDES_LOCK.writeLock().unlock();
        }
    }
}

