/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.netbeans.modules.j2ee.sun.validation.Validatee;
import org.netbeans.modules.j2ee.sun.validation.constraints.Constraint;
import org.netbeans.modules.j2ee.sun.validation.util.Utils;

class Validator {
    private static String SIZE_PREFIX = "size";
    private HashMap elementToConstraints = new HashMap();
    private Utils utils = new Utils();

    Validator() {
    }

    void addElementConstraint(String element, Constraint constraint) {
        ArrayList<Constraint> list = (ArrayList<Constraint>)this.elementToConstraints.get(element);
        if (null == list) {
            list = new ArrayList<Constraint>();
        }
        list.add(constraint);
        this.elementToConstraints.put(element, list);
    }

    Collection validate(String elementName, String elementDtdName, Validatee validatee) {
        ArrayList failures = new ArrayList();
        boolean isIndexed = validatee.isIndexed(elementName);
        if (isIndexed) {
            failures.addAll(this.validateProperties(elementName, elementDtdName, validatee));
        } else {
            failures.addAll(this.validateProperty(elementName, elementDtdName, validatee));
        }
        return failures;
    }

    Collection validateIndividualProperty(String property, String absoluteDtdName, String fieldName) {
        ArrayList failures = new ArrayList();
        String elementDtdName = this.utils.getName(absoluteDtdName, 47);
        ArrayList constraintList = (ArrayList)this.elementToConstraints.get(elementDtdName);
        if (constraintList != null) {
            failures.addAll(this.validate(property, constraintList, fieldName));
        }
        return failures;
    }

    private Collection validateProperty(String elementName, String elementDtdName, Validatee validatee) {
        ArrayList failures = new ArrayList();
        ArrayList constraintList = (ArrayList)this.elementToConstraints.get(elementDtdName);
        String name = validatee.getXPath() + "/" + elementDtdName;
        if (constraintList != null) {
            String property = (String)validatee.getElement(elementName);
            failures.addAll(this.validate(property, constraintList, name));
        }
        return failures;
    }

    private Collection validateProperties(String elementName, String elementDtdName, Validatee validatee) {
        ArrayList failures = new ArrayList();
        int noOfElements = 0;
        String sizeMethodName = this.utils.methodNameFromBeanName(elementName, SIZE_PREFIX);
        Method sizeMethod = validatee.getMethod(sizeMethodName);
        noOfElements = (Integer)validatee.invoke(sizeMethod);
        ArrayList constraintList = (ArrayList)this.elementToConstraints.get(elementDtdName);
        if (constraintList != null) {
            for (int i = 0; i < noOfElements; ++i) {
                String property = (String)validatee.getElement(elementName, i);
                String name = validatee.getXPath() + "/" + this.utils.getIndexedName(elementDtdName, i);
                failures.addAll(this.validate(property, constraintList, name));
            }
        }
        return failures;
    }

    private Collection validate(String value, ArrayList constraints, String name) {
        ArrayList failed_constrains = new ArrayList();
        int size = constraints.size();
        Constraint constraint = null;
        for (int i = 0; i < size; ++i) {
            constraint = (Constraint)constraints.get(i);
            failed_constrains.addAll(constraint.match(value, name));
        }
        return failed_constrains;
    }
}

