/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.binary.DualNode;
import com.oracle.truffle.js.nodes.control.AbstractBlockNode;
import com.oracle.truffle.js.nodes.control.DiscardResultNode;
import com.oracle.truffle.js.nodes.function.BlockScopeNode;
import com.oracle.truffle.js.nodes.function.FunctionBodyNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Dead;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.InteropList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class JSScope {
    protected final Node node;
    protected final MaterializedFrame mFrame;
    private static final String THIS_NAME = "this";

    public JSScope(Node node, MaterializedFrame frame) {
        this.node = node;
        this.mFrame = frame;
    }

    public static Iterable<Scope> createLocalScopes(Node node, final MaterializedFrame frame) {
        final JSScope scope = JSScope.createScope(node, frame);
        return new Iterable<Scope>(){

            @Override
            public Iterator<Scope> iterator() {
                return new Iterator<Scope>(){
                    private JSScope previousScope;
                    private JSScope nextScope;
                    {
                        this.nextScope = scope;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.nextScope == null) {
                            this.nextScope = this.previousScope.findParent();
                        }
                        return this.nextScope != null;
                    }

                    @Override
                    public Scope next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Scope vscope = this.nextScope.toScope(frame);
                        this.previousScope = this.nextScope;
                        this.nextScope = null;
                        return vscope;
                    }
                };
            }
        };
    }

    public static Iterable<Scope> createGlobalScopes(JSRealm realm) {
        Scope globalLexicalScope = Scope.newBuilder((String)"global", (Object)new DynamicScopeWrapper(realm.getGlobalScope())).build();
        Scope globalVarScope = Scope.newBuilder((String)"global", (Object)realm.getGlobalObject()).build();
        if (realm.getContext().getContextOptions().isScriptEngineGlobalScopeImport()) {
            Scope scriptEngineImportScope = Scope.newBuilder((String)"scriptEngineImport", (Object)realm.getScriptEngineImportScope()).build();
            return Arrays.asList(scriptEngineImportScope, globalLexicalScope, globalVarScope);
        }
        return Arrays.asList(globalLexicalScope, globalVarScope);
    }

    protected final Scope toScope(MaterializedFrame frame) {
        return Scope.newBuilder((String)this.getName(), (Object)this.getVariables((Frame)frame)).node(this.getNode()).arguments(this.getArguments((Frame)frame)).receiver(THIS_NAME, this.getThis((Frame)frame)).rootInstance(this.getFunctionObject()).build();
    }

    protected abstract String getName();

    protected abstract Node getNode();

    protected abstract Object getVariables(Frame var1);

    protected abstract Object getArguments(Frame var1);

    protected abstract Object getThis(Frame var1);

    protected final Object getFunctionObject() {
        if (this.mFrame == null) {
            return null;
        }
        Object[] args = this.mFrame.getArguments();
        return JSArguments.getFunctionObject(args);
    }

    protected abstract JSScope findParent();

    private static JSScope createScope(Node node, MaterializedFrame frame) {
        if (frame != null) {
            if (ScopeFrameNode.isBlockScopeFrame((Frame)frame)) {
                BlockScopeNode.FrameBlockScopeNode blockScopeNode = null;
                for (Node n = node; n != null; n = n.getParent()) {
                    if (!(n instanceof BlockScopeNode.FrameBlockScopeNode) || frame.getFrameDescriptor() != ((BlockScopeNode.FrameBlockScopeNode)n).getFrameDescriptor()) continue;
                    blockScopeNode = (BlockScopeNode.FrameBlockScopeNode)n;
                    break;
                }
                return new JSBlockScope(blockScopeNode, frame);
            }
        } else {
            for (Node n = node; n != null; n = n.getParent()) {
                if (!(n instanceof BlockScopeNode.FrameBlockScopeNode)) continue;
                return new JSBlockScope((BlockScopeNode.FrameBlockScopeNode)n, frame);
            }
        }
        return new JSFunctionScope(node, frame);
    }

    protected static Object createVariablesMapObject(FrameDescriptor frameDesc, MaterializedFrame frame, Object[] args) {
        assert (frame == null || frame.getFrameDescriptor() == frameDesc);
        LinkedHashMap<String, FrameSlotVariable> slotMap = new LinkedHashMap<String, FrameSlotVariable>();
        for (FrameSlot slot : frameDesc.getSlots()) {
            if (JSFrameUtil.isThisSlot(slot) || JSFrameUtil.isInternal(slot) || JSScope.isUnsetFrameSlot((Frame)frame, slot)) continue;
            String name = slot.getIdentifier().toString();
            slotMap.put(name, new FrameSlotVariable(slot));
        }
        return new VariablesMapObject(slotMap, args, (Frame)frame);
    }

    static boolean isUnsetFrameSlot(Frame frame, FrameSlot slot) {
        Object value;
        return frame != null && frame.isObject(slot) && ((value = FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)slot)) == null || value == Dead.instance() || value instanceof Frame);
    }

    protected Node findParentScopeNode() {
        Node parent;
        for (parent = this.node; parent != null && !(parent instanceof BlockScopeNode) && !(parent instanceof RootNode); parent = parent.getParent()) {
        }
        if (parent != null) {
            for (parent = parent.getParent(); parent != null && !(parent instanceof BlockScopeNode) && !(parent instanceof RootNode); parent = parent.getParent()) {
            }
        }
        return parent;
    }

    static Object getInteropValue(Object value) {
        if (JSRuntime.isLazyString(value)) {
            return value.toString();
        }
        if (value instanceof SafeInteger) {
            return ((SafeInteger)value).doubleValue();
        }
        if (value instanceof TruffleObject) {
            return value;
        }
        if (JSRuntime.isJSPrimitive(value)) {
            return value;
        }
        return JavaScriptLanguage.getCurrentEnv().asGuestValue(value);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class DynamicScopeWrapper
    implements TruffleObject {
        final DynamicObject scope;

        private DynamicScopeWrapper(DynamicObject scope) {
            this.scope = scope;
        }

        static boolean isConst(DynamicScopeWrapper wrapper, String name) {
            return JSProperty.isConst(wrapper.scope.getShape().getProperty((Object)name));
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object getMembers(boolean includeInternal) {
            ArrayList<String> keys = new ArrayList<String>();
            for (Object key : this.scope.getShape().getKeys()) {
                Object value;
                if (!(key instanceof String) || (value = this.scope.get(key)) == null || value == Dead.instance()) continue;
                keys.add((String)key);
            }
            return InteropList.create(keys);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberReadable(String name) {
            Object value = this.scope.get((Object)name);
            return value != null && value != Dead.instance();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberModifiable(String name) {
            return this.isMemberReadable(name) && !DynamicScopeWrapper.isConst(this, name);
        }

        @ExportMessage
        boolean isMemberInsertable(String name) {
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readMember(String name) throws UnknownIdentifierException {
            Object value = this.scope.get((Object)name);
            if (value == null || value == Dead.instance()) {
                throw UnknownIdentifierException.create((String)name);
            }
            return JSScope.getInteropValue(value);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        void writeMember(String name, Object value) throws UnsupportedMessageException, UnknownIdentifierException {
            Object curValue = this.scope.get((Object)name);
            if (curValue == null || curValue == Dead.instance()) {
                throw UnknownIdentifierException.create((String)name);
            }
            if (DynamicScopeWrapper.isConst(this, name)) {
                throw UnsupportedMessageException.create();
            }
            this.scope.set((Object)name, value);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class VariablesMapObject
    implements TruffleObject {
        final Map<String, ? extends Variable> slots;
        final Object[] args;
        final Frame frame;

        private VariablesMapObject(Map<String, ? extends Variable> slots, Object[] args, Frame frame) {
            this.slots = slots;
            this.args = args;
            this.frame = frame;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object getMembers(boolean includeInternal) {
            ArrayList<String> names = new ArrayList<String>(this.slots.keySet());
            return InteropList.create(names);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberReadable(String name) {
            Variable slot = this.slots.get(name);
            return slot != null;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberModifiable(String name) {
            Variable slot = this.slots.get(name);
            if (slot == null) {
                return false;
            }
            if (this.frame == null) {
                return false;
            }
            return slot.isWritable();
        }

        @ExportMessage
        boolean isMemberInsertable(String name) {
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readMember(String name) throws UnknownIdentifierException {
            Variable slot = this.slots.get(name);
            if (slot == null) {
                throw UnknownIdentifierException.create((String)name);
            }
            if (this.frame == null) {
                return Undefined.instance;
            }
            Object value = slot.get(this.frame, this.args);
            return JSScope.getInteropValue(value);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        void writeMember(String name, Object value) throws UnsupportedMessageException, UnknownIdentifierException {
            if (this.frame == null) {
                throw UnsupportedMessageException.create();
            }
            Variable slot = this.slots.get(name);
            if (slot == null) {
                throw UnknownIdentifierException.create((String)name);
            }
            if (!slot.isWritable()) {
                throw UnsupportedMessageException.create();
            }
            slot.set(this.frame, this.args, value);
        }
    }

    public static class JSFunctionScope
    extends JSScope {
        private final RootNode rootNode;

        protected JSFunctionScope(Node node, MaterializedFrame frame) {
            super(node, JSFunctionScope.getFunctionFrame(frame));
            this.rootNode = JSFunctionScope.findRootNode(node);
            assert (frame == null || this.rootNode == null || this.rootNode instanceof JavaScriptRootNode && ((JavaScriptRootNode)this.rootNode).isResumption() || frame.getFrameDescriptor() == this.rootNode.getFrameDescriptor());
        }

        private static MaterializedFrame getFunctionFrame(MaterializedFrame frame) {
            Object arg0;
            if (frame != null && frame.getArguments().length > 0 && (arg0 = frame.getArguments()[0]) instanceof MaterializedFrame) {
                return (MaterializedFrame)arg0;
            }
            return frame;
        }

        private static RootNode findRootNode(Node node) {
            Node n;
            for (n = node; !(n instanceof RootNode) && n != null; n = n.getParent()) {
            }
            return (RootNode)n;
        }

        @Override
        protected String getName() {
            if (this.rootNode == null) {
                return "unknown";
            }
            return this.rootNode.getName();
        }

        @Override
        protected Node getNode() {
            return this.rootNode;
        }

        @Override
        protected Object getVariables(Frame frame) {
            return JSFunctionScope.createVariablesMapObject(this.mFrame != null ? this.mFrame.getFrameDescriptor() : this.rootNode.getFrameDescriptor(), this.mFrame, null);
        }

        @Override
        protected Object getArguments(Frame frame) {
            if (this.rootNode == null || this.mFrame == null) {
                return null;
            }
            return new VariablesMapObject(JSFunctionScope.collectArgs((Node)this.rootNode), this.mFrame.getArguments(), (Frame)this.mFrame);
        }

        @Override
        protected Object getThis(Frame frame) {
            Object[] args;
            Object function;
            if (this.mFrame == null) {
                return null;
            }
            FrameSlot thisSlot = JSFrameUtil.getThisSlot(this.mFrame.getFrameDescriptor());
            if (thisSlot == null) {
                return JSFunctionScope.thisFromArguments(this.mFrame.getArguments());
            }
            Object thiz = this.mFrame.getValue(thisSlot);
            if (thiz == Undefined.instance && JSFunction.isJSFunction(function = JSArguments.getFunctionObject(args = this.mFrame.getArguments()))) {
                DynamicObject jsFunction = (DynamicObject)function;
                thiz = JSFunctionScope.isArrowFunctionWithThisCaptured(jsFunction) ? JSFunction.getLexicalThis(jsFunction) : JSFunctionScope.thisFromArguments(args);
            }
            return thiz;
        }

        private static Object thisFromArguments(Object[] args) {
            Object thisObject = JSArguments.getThisObject(args);
            Object function = JSArguments.getFunctionObject(args);
            if (JSFunction.isJSFunction(function) && !JSFunction.isStrict((DynamicObject)function)) {
                JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
                thisObject = thisObject == Undefined.instance || thisObject == Null.instance ? realm.getGlobalObject() : JSRuntime.toObject(realm.getContext(), thisObject);
            }
            return thisObject;
        }

        private static boolean isArrowFunctionWithThisCaptured(DynamicObject function) {
            return !JSFunction.isConstructor(function) && JSFunction.isClassPrototypeInitialized(function);
        }

        private static Map<String, ? extends Variable> collectArgs(Node block) {
            final LinkedHashMap args = new LinkedHashMap(4);
            NodeUtil.forEachChild((Node)block, (NodeVisitor)new NodeVisitor(){
                private JSWriteFrameSlotNode wn;

                public boolean visit(Node node) {
                    if (node instanceof JSWriteFrameSlotNode) {
                        this.wn = (JSWriteFrameSlotNode)node;
                        boolean all = NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
                        this.wn = null;
                        return all;
                    }
                    if (this.wn != null && node instanceof AccessIndexedArgumentNode) {
                        FrameSlot slot = this.wn.getFrameSlot();
                        if (!JSFrameUtil.isInternal(slot)) {
                            String name = Objects.toString(slot.getIdentifier());
                            int argIndex = 2 + ((AccessIndexedArgumentNode)node).getIndex();
                            assert (!args.containsKey(name)) : name + " argument exists already.";
                            args.put(name, new ArgumentVariable(argIndex));
                        }
                        return true;
                    }
                    if (!(node instanceof JavaScriptBaseNode) || node instanceof InstrumentableNode.WrapperNode || node instanceof AbstractBlockNode || node instanceof FunctionBodyNode || node instanceof DualNode || node instanceof DiscardResultNode) {
                        return NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
                    }
                    return true;
                }
            });
            return args;
        }

        @Override
        protected JSScope findParent() {
            if (this.mFrame == null) {
                return null;
            }
            MaterializedFrame parentFrame = JSFrameUtil.getParentFrame((Frame)this.mFrame);
            if (parentFrame != null && parentFrame != JSFrameUtil.NULL_MATERIALIZED_FRAME) {
                return JSScope.createScope(null, JSFrameUtil.getParentFrame((Frame)this.mFrame));
            }
            return null;
        }
    }

    public static class JSBlockScope
    extends JSScope {
        private final BlockScopeNode.FrameBlockScopeNode blockScopeNode;

        protected JSBlockScope(BlockScopeNode.FrameBlockScopeNode blockScopeNode, MaterializedFrame frame) {
            super(blockScopeNode, frame);
            this.blockScopeNode = blockScopeNode;
            assert (frame == null || blockScopeNode == null || frame.getFrameDescriptor() == blockScopeNode.getFrameDescriptor());
        }

        @Override
        protected String getName() {
            String locationStr = "";
            if (this.node != null && this.node.getSourceSection() != null) {
                locationStr = " at " + this.node.getSourceSection().getSource().getName() + ":" + this.node.getSourceSection().getStartLine();
            }
            return "JS block scope" + locationStr;
        }

        @Override
        protected Node getNode() {
            return this.blockScopeNode;
        }

        @Override
        protected Object getVariables(Frame frame) {
            MaterializedFrame f;
            if (this.mFrame == null && frame == null) {
                return new VariablesMapObject(Collections.emptyMap(), null, null);
            }
            MaterializedFrame materializedFrame = f = this.mFrame != null ? this.mFrame : frame.materialize();
            assert (this.blockScopeNode == null || f.getFrameDescriptor() == this.blockScopeNode.getFrameDescriptor());
            return JSBlockScope.createVariablesMapObject(f.getFrameDescriptor(), f, null);
        }

        @Override
        protected Object getArguments(Frame frame) {
            return null;
        }

        @Override
        protected Object getThis(Frame frame) {
            return null;
        }

        @Override
        protected JSScope findParent() {
            if (this.mFrame == null) {
                return null;
            }
            Node parent = this.findParentScopeNode();
            if (parent == null) {
                return null;
            }
            Frame parentFrame = (Frame)FrameUtil.getObjectSafe((Frame)this.mFrame, (FrameSlot)this.mFrame.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER));
            return JSScope.createScope(parent, parentFrame.materialize());
        }
    }

    static final class ArgumentVariable
    extends Variable {
        private final int index;

        ArgumentVariable(int index) {
            this.index = index;
        }

        @Override
        public Object get(Frame frame, Object[] args) {
            if (this.index >= args.length) {
                return Undefined.instance;
            }
            return args[this.index];
        }

        @Override
        public void set(Frame frame, Object[] args, Object value) {
        }

        @Override
        public boolean isWritable() {
            return false;
        }
    }

    static final class FrameSlotVariable
    extends Variable {
        private final FrameSlot slot;
        private final boolean writable;

        FrameSlotVariable(FrameSlot slot) {
            this.slot = slot;
            this.writable = !JSFrameUtil.isConst(slot) && !JSFrameUtil.isInternal(slot);
        }

        @Override
        public Object get(Frame frame, Object[] args) {
            assert (!JSScope.isUnsetFrameSlot(frame, this.slot));
            return frame.getValue(this.slot);
        }

        @Override
        public void set(Frame frame, Object[] args, Object value) {
            if (frame.isInt(this.slot) && value instanceof Integer) {
                frame.setInt(this.slot, ((Integer)value).intValue());
            } else if (frame.isDouble(this.slot) && value instanceof Double) {
                frame.setDouble(this.slot, ((Double)value).doubleValue());
            } else if (frame.isBoolean(this.slot) && value instanceof Boolean) {
                frame.setBoolean(this.slot, ((Boolean)value).booleanValue());
            } else {
                frame.setObject(this.slot, value);
            }
        }

        @Override
        public boolean isWritable() {
            return this.writable;
        }
    }

    static abstract class Variable {
        Variable() {
        }

        public abstract Object get(Frame var1, Object[] var2);

        public abstract void set(Frame var1, Object[] var2, Object var3);

        public abstract boolean isWritable();
    }
}

