/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNodeGen;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import java.math.BigInteger;

public abstract class JSStringToNumberNode
extends JavaScriptBaseNode {
    static final int PREFIX_LENGTH = 2;
    static final int SAFE_HEX_DIGITS = 15;
    static final int SAFE_OCTAL_DIGITS = 19;
    static final int SAFE_BINARY_DIGITS = 55;
    static final int MAX_SAFE_INTEGER_LENGTH = 17;
    static final int SMALL_INT_LENGTH = 9;
    @Node.Child
    private JSTrimWhitespaceNode trimWhitespaceNode;

    public final double executeString(String input) {
        if (this.trimWhitespaceNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.trimWhitespaceNode = (JSTrimWhitespaceNode)this.insert(JSTrimWhitespaceNode.create());
        }
        return this.executeNoTrim(this.trimWhitespaceNode.executeString(input));
    }

    protected abstract double executeNoTrim(String var1);

    public static JSStringToNumberNode create() {
        return JSStringToNumberNodeGen.create();
    }

    protected static final boolean startsWithI(String input) {
        return input.length() >= "Infinity".length() && input.length() <= "Infinity".length() + 1 && (input.charAt(0) == 'I' || input.charAt(1) == 'I');
    }

    protected static final boolean startsWithValidDouble(String input) {
        char firstChar = input.charAt(0);
        if (JSRuntime.isAsciiDigit(firstChar) || firstChar == '-' || firstChar == '.' || firstChar == '+') {
            if (input.length() >= 2) {
                char secondChar = input.charAt(1);
                return JSRuntime.isAsciiDigit(secondChar) || secondChar == '.' || secondChar == 'e' || secondChar == 'E';
            }
            return true;
        }
        return false;
    }

    protected static final boolean startsWithValidInt(String input) {
        char firstChar = input.charAt(0);
        return !(!JSRuntime.isAsciiDigit(firstChar) && firstChar != '-' && firstChar != '+' || input.length() >= 2 && !JSRuntime.isAsciiDigit(input.charAt(1)));
    }

    protected static final boolean allDigits(String input, int maxLength) {
        assert (input.length() <= maxLength);
        for (int i = 0; i < maxLength; ++i) {
            if (i >= input.length()) {
                return true;
            }
            if (JSRuntime.isAsciiDigit(input.charAt(i))) continue;
            return false;
        }
        return false;
    }

    protected static final boolean isHex(String input) {
        return input.length() >= 2 && input.charAt(0) == '0' && (input.charAt(1) == 'x' || input.charAt(1) == 'X');
    }

    protected static final boolean isOctal(String input) {
        return input.length() >= 2 && input.charAt(0) == '0' && (input.charAt(1) == 'o' || input.charAt(1) == 'O');
    }

    protected static final boolean isBinary(String input) {
        return input.length() >= 2 && input.charAt(0) == '0' && (input.charAt(1) == 'b' || input.charAt(1) == 'B');
    }

    @Specialization(guards={"input.length() == 0"})
    protected double doLengthIsZero(String input) {
        return 0.0;
    }

    @Specialization(guards={"startsWithI(input)"})
    protected double doInfinity(String input, @Cached(value="createBinaryProfile()") ConditionProfile endsWithInfinity) {
        if (endsWithInfinity.profile(input.endsWith("Infinity"))) {
            return JSRuntime.identifyInfinity(input, input.charAt(0));
        }
        return Double.NaN;
    }

    @Specialization(guards={"input.length() > 0", "!startsWithI(input)", "!startsWithValidDouble(input)", "!isHex(input)", "!isOctal(input)", "!isBinary(input)"})
    protected double doNaN(String input) {
        return Double.NaN;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isHex(input)", "input.length() <= SAFE_HEX_DIGITS"})
    protected double doHexSafe(String input) {
        return JSStringToNumberNode.safeIntegerToDouble(JSRuntime.parseSafeInteger(input, 2, input.length(), 16));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isHex(input)", "input.length() > SAFE_HEX_DIGITS"})
    protected double doHex(String input) {
        try {
            return new BigInteger(input.substring(2), 16).doubleValue();
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isOctal(input)", "input.length() <= SAFE_OCTAL_DIGITS"})
    protected double doOctalSafe(String input) {
        return JSStringToNumberNode.safeIntegerToDouble(JSRuntime.parseSafeInteger(input, 2, input.length(), 8));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isOctal(input)", "input.length() > SAFE_OCTAL_DIGITS"})
    protected double doOctal(String input) {
        try {
            return new BigInteger(input.substring(2), 8).doubleValue();
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isBinary(input)", "input.length() <= SAFE_BINARY_DIGITS"})
    protected double doBinarySafe(String input) {
        return JSStringToNumberNode.safeIntegerToDouble(JSRuntime.parseSafeInteger(input, 2, input.length(), 2));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isBinary(input)", "input.length() > SAFE_BINARY_DIGITS"})
    protected double doBinary(String input) {
        try {
            return new BigInteger(input.substring(2), 2).doubleValue();
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    @Specialization(guards={"input.length() > 0", "input.length() <= SMALL_INT_LENGTH", "allDigits(input, SMALL_INT_LENGTH)"})
    protected double doSmallPosInt(String input) {
        int result = 0;
        int len = input.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = input.charAt(pos);
            assert (JSRuntime.isAsciiDigit(c));
            result *= 10;
            result += c - 48;
        }
        assert (result >= 0 && JSStringToNumberNode.checkLongResult(result, input));
        return result;
    }

    @Specialization(guards={"input.length() > 0", "input.length() <= MAX_SAFE_INTEGER_LENGTH", "startsWithValidInt(input)"}, rewriteOn={SlowPathException.class}, replaces={"doSmallPosInt"})
    protected double doInteger(String input) throws SlowPathException {
        long result = JSRuntime.parseSafeInteger(input);
        if (result == Long.MIN_VALUE) {
            throw JSNodeUtil.slowPathException();
        }
        assert (JSStringToNumberNode.checkLongResult(result, input));
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"input.length() > 0", "startsWithValidDouble(input)"}, replaces={"doInteger"})
    protected double doDouble(String input) {
        return JSRuntime.parseDoubleOrNaN(input);
    }

    private static double safeIntegerToDouble(long result) {
        if (result == Long.MIN_VALUE) {
            return Double.NaN;
        }
        assert (JSRuntime.isSafeInteger(result));
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean checkLongResult(long result, String input) {
        return Double.compare(result, JSRuntime.parseDoubleOrNaN(input)) == 0;
    }
}

