/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.Assignment;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class BinaryNode
extends Expression
implements Assignment<Expression> {
    private final Expression lhs;
    private final Expression rhs;

    public BinaryNode(long l, Expression expression, Expression expression2) {
        super(l, Math.min(expression.getStart(), expression2.getStart()), Math.max(expression2.getFinish(), expression.getFinish()));
        assert (!this.isTokenType(TokenType.AND) && !this.isTokenType(TokenType.OR) || expression instanceof JoinPredecessorExpression);
        this.lhs = expression;
        this.rhs = expression2;
    }

    private BinaryNode(BinaryNode binaryNode, Expression expression, Expression expression2) {
        super(binaryNode);
        this.lhs = expression;
        this.rhs = expression2;
    }

    public boolean isComparison() {
        switch (this.tokenType()) {
            case EQ: 
            case EQ_STRICT: 
            case NE: 
            case NE_STRICT: 
            case LE: 
            case LT: 
            case GE: 
            case GT: {
                return true;
            }
        }
        return false;
    }

    public boolean isRelational() {
        switch (this.tokenType()) {
            case LE: 
            case LT: 
            case GE: 
            case GT: {
                return true;
            }
        }
        return false;
    }

    public boolean isLogical() {
        return BinaryNode.isLogical(this.tokenType());
    }

    public static boolean isLogical(TokenType tokenType) {
        switch (tokenType) {
            case AND: 
            case OR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAssignment() {
        return this.tokenType().isAssignment();
    }

    @Override
    public boolean isSelfModifying() {
        return this.isAssignment() && !this.isTokenType(TokenType.ASSIGN);
    }

    @Override
    public Expression getAssignmentDest() {
        return this.isAssignment() ? this.lhs() : null;
    }

    @Override
    public Expression getAssignmentSource() {
        return this.rhs();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterBinaryNode(this)) {
            return nodeVisitor.leaveBinaryNode(this.setLHS((Expression)this.lhs.accept(nodeVisitor)).setRHS((Expression)this.rhs.accept(nodeVisitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterBinaryNode(this);
    }

    @Override
    public boolean isAlwaysFalse() {
        switch (this.tokenType()) {
            case COMMALEFT: {
                return this.lhs.isAlwaysFalse();
            }
            case COMMARIGHT: {
                return this.rhs.isAlwaysFalse();
            }
        }
        return false;
    }

    @Override
    public boolean isAlwaysTrue() {
        switch (this.tokenType()) {
            case COMMALEFT: {
                return this.lhs.isAlwaysTrue();
            }
            case COMMARIGHT: {
                return this.rhs.isAlwaysTrue();
            }
        }
        return false;
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        TokenType tokenType = this.tokenType();
        boolean bl2 = tokenType.needsParens(this.lhs().tokenType(), true);
        boolean bl3 = tokenType.needsParens(this.rhs().tokenType(), false);
        if (bl2) {
            stringBuilder.append('(');
        }
        this.lhs().toString(stringBuilder, bl);
        if (bl2) {
            stringBuilder.append(')');
        }
        stringBuilder.append(' ');
        switch (tokenType) {
            case COMMALEFT: {
                stringBuilder.append(",<");
                break;
            }
            case COMMARIGHT: {
                stringBuilder.append(",>");
                break;
            }
            case INCPREFIX: 
            case DECPREFIX: {
                stringBuilder.append("++");
                break;
            }
            default: {
                stringBuilder.append(tokenType.getName());
            }
        }
        stringBuilder.append(' ');
        if (bl3) {
            stringBuilder.append('(');
        }
        this.rhs().toString(stringBuilder, bl);
        if (bl3) {
            stringBuilder.append(')');
        }
    }

    public Expression lhs() {
        return this.lhs;
    }

    public Expression rhs() {
        return this.rhs;
    }

    public BinaryNode setLHS(Expression expression) {
        if (this.lhs == expression) {
            return this;
        }
        return new BinaryNode(this, expression, this.rhs);
    }

    public BinaryNode setRHS(Expression expression) {
        if (this.rhs == expression) {
            return this;
        }
        return new BinaryNode(this, this.lhs, expression);
    }
}

