/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.options;

import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.nette.tester.util.TesterUtils;

public class TesterOptionsValidator {
    private final ValidationResult result = new ValidationResult();

    public TesterOptionsValidator validate(String testerPath, String phpIniPath) {
        this.validateTesterPath(testerPath);
        this.validatePhpIniPath(phpIniPath);
        return this;
    }

    public ValidationResult getResult() {
        return this.result;
    }

    public TesterOptionsValidator validateTesterPath(String testerPath) {
        String warning = TesterUtils.validateTesterPath(testerPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"tester.path", warning));
        }
        return this;
    }

    public TesterOptionsValidator validatePhpIniPath(String phpIniPath) {
        String warning;
        if (StringUtils.hasText((String)phpIniPath) && (warning = TesterUtils.validatePhpIniPath(phpIniPath)) != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"php.ini.path", warning));
        }
        return this;
    }
}

