/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.UIManager;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.Places;
import org.openide.util.NbBundle;

public class Utils {
    private Utils() {
    }

    public static Graphics2D prepareGraphics(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Map rhints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (rhints == null && Boolean.getBoolean("swing.aatext")) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (rhints != null) {
            g2.addRenderingHints(rhints);
        }
        return g2;
    }

    public static void showURL(String href) {
        try {
            HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
            if (displayer != null) {
                displayer.showURL(new URL(href));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int getDefaultFontSize() {
        Integer customFontSize = (Integer)UIManager.get("customFontSize");
        if (customFontSize != null) {
            return customFontSize;
        }
        Font systemDefaultFont = UIManager.getFont("TextField.font");
        return systemDefaultFont != null ? systemDefaultFont.getSize() : 11;
    }

    public static Action findAction(String key) {
        FileObject fo = FileUtil.getConfigFile((String)key);
        if (fo != null && fo.isValid()) {
            try {
                Object instance;
                DataObject dob = DataObject.find((FileObject)fo);
                InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                if (ic != null && (instance = ic.instanceCreate()) instanceof Action) {
                    Action a = (Action)instance;
                    return a;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static Color getColor(String resId) {
        ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.welcome.resources.Bundle");
        try {
            Integer rgb = Integer.decode(bundle.getString(resId));
            return new Color(rgb);
        }
        catch (NumberFormatException nfE) {
            ErrorManager.getDefault().notify(1, (Throwable)nfE);
            return Color.BLACK;
        }
    }

    public static Color getLinkColor() {
        Color res = UIManager.getColor("nb.html.link.foreground");
        if (null == res) {
            res = Utils.getColor("LinkColor");
        }
        return res;
    }

    public static Color getFocusedLinkColor() {
        Color res = UIManager.getColor("nb.html.link.foreground.focus");
        if (null == res) {
            res = Utils.getColor("LinkInFocusColor");
        }
        return res;
    }

    public static Color getVisitedLinkColor() {
        Color res = UIManager.getColor("nb.html.link.foreground.visited");
        if (null == res) {
            res = Utils.getColor("VisitedLinkColor");
        }
        return res;
    }

    public static Color getBottomBarColor() {
        Color res = UIManager.getColor("nb.startpage.bottombar.background");
        if (null == res) {
            res = Utils.getColor("BottomBarColor");
        }
        return res;
    }

    public static Color getTopBarForeground() {
        Color res = UIManager.getColor("nb.startpage.topbar.foreground");
        if (null == res) {
            res = Utils.getColor("TabForegroundColor");
        }
        return res;
    }

    public static Color getTopBarColor() {
        Color res = UIManager.getColor("nb.startpage.topbar.background");
        if (null == res) {
            res = Utils.getColor("TabBackgroundColor");
        }
        return res;
    }

    public static Color getBorderColor() {
        Color res = UIManager.getColor("nb.startpage.border.color");
        if (null == res) {
            res = Utils.getColor("BorderColor");
        }
        return res;
    }

    public static Color getTabBorder1Color() {
        Color res = UIManager.getColor("nb.startpage.tab.border1.color");
        if (null == res) {
            res = Utils.getColor("TabBorder1Color");
        }
        return res;
    }

    public static Color getTabBorder2Color() {
        Color res = UIManager.getColor("nb.startpage.tab.border2.color");
        if (null == res) {
            res = Utils.getColor("TabBorder2Color");
        }
        return res;
    }

    public static Color getRssHeaderColor() {
        Color res = UIManager.getColor("nb.startpage.rss.header.color");
        if (null == res) {
            res = Utils.getColor("HeaderForegroundColor");
        }
        return res;
    }

    public static Color getRssDetailsColor() {
        Color res = UIManager.getColor("nb.startpage.rss.details.color");
        if (null == res) {
            res = Utils.getColor("RssDetailsColor");
        }
        return res;
    }

    public static Color getRssDateColor() {
        Color res = UIManager.getColor("nb.startpage.rss.date.color");
        if (null == res) {
            res = Utils.getColor("RssDateTimeColor");
        }
        return res;
    }

    public static boolean isDefaultButtons() {
        return UIManager.getBoolean("nb.startpage.defaultbuttonborder");
    }

    public static boolean isSimpleTabs() {
        return UIManager.getBoolean("nb.startpage.simpletabs");
    }

    public static File getCacheStore() throws IOException {
        return Places.getCacheSubdirectory((String)"welcome");
    }

    public static String getUrlString(DataObject dob) {
        try {
            Method m = dob.getClass().getDeclaredMethod("getURLString", new Class[0]);
            m.setAccessible(true);
            Object res = m.invoke((Object)dob, new Object[0]);
            if (null != res) {
                return res.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

