/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractElementVisitor9;
import javax.lang.model.util.ElementFilter;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lsp.HyperlinkLocation;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.lib.editor.util.StringEscapeUtils;
import org.netbeans.modules.editor.java.JavaCompletionDoc;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.editor.java.TreeShims;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.base.javadoc.JavadocImports;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.lsp.HyperlinkLocationProvider;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GoToSupport {
    private static final Set<JavaTokenId> USABLE_TOKEN_IDS = EnumSet.of(JavaTokenId.IDENTIFIER, JavaTokenId.THIS, JavaTokenId.SUPER, JavaTokenId.ARROW);
    private static String[] c = new String[]{"&", "<", ">", "\n", "\""};
    private static String[] tags = new String[]{"&amp;", "&lt;", "&gt;", "<br>", "&quot;"};
    static UiUtilsCaller CALLER = new UiUtilsCaller(){

        @Override
        public boolean open(FileObject fo, int pos) {
            return UiUtils.open((FileObject)fo, (int)pos);
        }

        @Override
        public void beep(boolean goToSource, boolean goToJavadoc) {
            Toolkit.getDefaultToolkit().beep();
            int value = goToSource ? 1 : (goToJavadoc ? 2 : 0);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToSupport.class, (String)"WARN_CannotGoToGeneric", (Object)value));
        }

        @Override
        public boolean open(ClasspathInfo info, ElementHandle<?> el) {
            return ElementOpen.open((ClasspathInfo)info, el);
        }

        @Override
        public void warnCannotOpen(String displayName) {
            Toolkit.getDefaultToolkit().beep();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToSupport.class, (String)"WARN_CannotGoTo", (Object)displayName));
        }
    };

    private static FileObject getFileObject(Document doc) {
        DataObject od = (DataObject)doc.getProperty("stream");
        return od != null ? od.getPrimaryFile() : null;
    }

    public static String getGoToElementTooltip(final Document doc, final int offset, final boolean goToSource, final HyperlinkType type) {
        try {
            FileObject fo = GoToSupport.getFileObject(doc);
            if (fo == null) {
                return null;
            }
            final String[] result = new String[1];
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController controller;
                    Parser.Result res = resultIterator.getParserResult(offset);
                    CompilationController compilationController = controller = res != null ? CompilationController.get((Parser.Result)res) : null;
                    if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    Context resolved = GoToSupport.resolveContext((CompilationInfo)controller, doc, offset, goToSource, true);
                    if (resolved != null) {
                        result[0] = GoToSupport.computeTooltip((CompilationInfo)controller, doc, resolved, type);
                    }
                }
            });
            return result[0];
        }
        catch (ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static CompletableFuture<HyperlinkLocation> getGoToLocation(final Document doc, final int offset) {
        try {
            FileObject fo = GoToSupport.getFileObject(doc);
            if (fo != null) {
                final GoToTarget[] target = new GoToTarget[1];
                final LineMap[] lineMap = new LineMap[1];
                ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController controller;
                        Parser.Result res = resultIterator.getParserResult(offset);
                        CompilationController compilationController = controller = res != null ? CompilationController.get((Parser.Result)res) : null;
                        if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            return;
                        }
                        Context resolved = GoToSupport.resolveContext((CompilationInfo)controller, doc, offset, false, false);
                        target[0] = resolved == null ? new GoToTarget(-1, -1, null, null, null, null, null, false) : GoToSupport.computeGoToTarget(controller, resolved, offset);
                        lineMap[0] = controller.getCompilationUnit().getLineMap();
                    }
                });
                if (target[0] != null && target[0].success) {
                    if (target[0].offsetToOpen < 0) {
                        CompletableFuture future = ElementOpen.getLocation((ClasspathInfo)target[0].cpInfo, (ElementHandle)target[0].elementToOpen, (String)target[0].resourceName);
                        return future.thenApply(location -> location != null ? HyperlinkLocationProvider.createHyperlinkLocation((FileObject)location.getFileObject(), (int)location.getStartOffset(), (int)location.getEndOffset()) : null);
                    }
                    int start = target[0].nameSpan != null ? target[0].nameSpan[0] : target[0].offsetToOpen;
                    int end = target[0].nameSpan != null ? target[0].nameSpan[1] : target[0].endPos;
                    return CompletableFuture.completedFuture(HyperlinkLocationProvider.createHyperlinkLocation((FileObject)fo, (int)start, (int)end));
                }
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static boolean isError(Element el) {
        return el == null || el.asType() == null || el.asType().getKind() == TypeKind.ERROR;
    }

    private static void performGoTo(final Document doc, final int offset, final boolean goToSource, final boolean javadoc) {
        final AtomicBoolean cancel = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GoToSupport.performGoToImpl(doc, offset, goToSource, javadoc, cancel);
            }
        }, (String)NbBundle.getMessage(GoToSupport.class, (String)(javadoc ? "LBL_GoToJavadoc" : (goToSource ? "LBL_GoToSource" : "LBL_GoToDeclaration"))), (AtomicBoolean)cancel, (boolean)false);
    }

    private static void performGoToImpl(final Document doc, final int offset, final boolean goToSource, final boolean javadoc, final AtomicBoolean cancel) {
        try {
            FileObject fo = GoToSupport.getFileObject(doc);
            if (fo == null) {
                return;
            }
            final GoToTarget[] target = new GoToTarget[1];
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController controller;
                    Parser.Result res = resultIterator.getParserResult(offset);
                    if (cancel != null && cancel.get()) {
                        return;
                    }
                    CompilationController compilationController = controller = res != null ? CompilationController.get((Parser.Result)res) : null;
                    if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    Context resolved = GoToSupport.resolveContext((CompilationInfo)controller, doc, offset, goToSource, false);
                    if (resolved == null) {
                        target[0] = new GoToTarget(-1, -1, null, null, null, null, null, false);
                        return;
                    }
                    if (javadoc) {
                        URL url = SourceUtils.getPreferredJavadoc((Element)resolved.resolved);
                        if (url != null) {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                        } else {
                            target[0] = new GoToTarget(-1, -1, null, null, null, null, null, false);
                        }
                    } else {
                        target[0] = GoToSupport.computeGoToTarget(controller, resolved, offset);
                    }
                }
            });
            if (target[0] != null) {
                boolean openSucceeded = false;
                if (cancel.get()) {
                    return;
                }
                if (!target[0].success) {
                    CALLER.beep(goToSource, javadoc);
                } else {
                    if (target[0].offsetToOpen >= 0) {
                        openSucceeded = CALLER.open(fo, target[0].offsetToOpen);
                    } else if (target[0].elementToOpen != null) {
                        openSucceeded = CALLER.open(target[0].cpInfo, target[0].elementToOpen);
                    }
                    if (!openSucceeded) {
                        CALLER.warnCannotOpen(target[0].displayNameForError);
                    }
                }
            }
        }
        catch (ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static GoToTarget computeGoToTarget(CompilationController controller, Context resolved, int offset) {
        TreePath elpath = GoToSupport.getPath((CompilationInfo)controller, resolved.resolved);
        if (elpath != null) {
            Tree tree = elpath.getLeaf();
            long startPos = controller.getTrees().getSourcePositions().getStartPosition(controller.getCompilationUnit(), tree);
            if (startPos != -1L) {
                if (GoToSupport.isCaretInsideDeclarationName((CompilationInfo)controller, tree, elpath, offset)) {
                    return new GoToTarget(-1, -1, null, null, null, null, null, false);
                }
                long endPos = controller.getTrees().getSourcePositions().getEndPosition(controller.getCompilationUnit(), tree);
                return new GoToTarget(controller.getSnapshot().getOriginalOffset((int)startPos), controller.getSnapshot().getOriginalOffset((int)endPos), GoToSupport.getNameSpan(tree, controller.getTreeUtilities()), null, null, null, controller.getElementUtilities().getElementName(resolved.resolved, false).toString(), true);
            }
            return new GoToTarget(-1, -1, null, null, null, null, null, false);
        }
        TypeElement te = resolved.resolved != null ? controller.getElementUtilities().outermostTypeElement(resolved.resolved) : null;
        return new GoToTarget(-1, -1, null, controller.getClasspathInfo(), ElementHandle.create((Element)resolved.resolved), te != null ? te.getQualifiedName().toString().replace('.', '/') + ".class" : null, controller.getElementUtilities().getElementName(resolved.resolved, false).toString(), true);
    }

    public static int[] getNameSpan(Tree tree, TreeUtilities tu) {
        int[] span = null;
        switch (tree.getKind()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                span = tu.findNameSpan((ClassTree)tree);
                break;
            }
            case METHOD: {
                span = tu.findNameSpan((MethodTree)tree);
                break;
            }
            case VARIABLE: {
                span = tu.findNameSpan((VariableTree)tree);
            }
        }
        return span;
    }

    public static void goTo(Document doc, int offset, boolean goToSource) {
        GoToSupport.performGoTo(doc, offset, goToSource, false);
    }

    public static void goToJavadoc(Document doc, int offset) {
        GoToSupport.performGoTo(doc, offset, false, true);
    }

    public static Context resolveContext(CompilationInfo controller, Document doc, int offset, boolean goToSource, boolean tooltip) {
        Token[] token = new Token[1];
        int[] span = GoToSupport.getIdentifierOrLambdaArrowSpan(doc, offset, token);
        if (span == null) {
            return null;
        }
        int exactOffset = controller.getSnapshot().getEmbeddedOffset(span[0] + 1);
        Element el = null;
        TypeMirror classType = null;
        boolean insideImportStmt = false;
        TreePath path = controller.getTreeUtilities().pathFor(exactOffset);
        if (token[0] != null && token[0].id() == JavaTokenId.JAVADOC_COMMENT) {
            el = JavadocImports.findReferencedElement((CompilationInfo)controller, (int)offset);
        } else {
            TreePath parent = (path = GoToSupport.adjustPathForModuleName(path)).getParentPath();
            if (parent != null) {
                Tree parentLeaf = parent.getLeaf();
                if (parentLeaf.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)parentLeaf).getIdentifier() == path.getLeaf()) {
                    if (!GoToSupport.isError(controller.getTrees().getElement(path.getParentPath()))) {
                        path = path.getParentPath();
                    }
                } else if (parentLeaf.getKind() == Tree.Kind.IMPORT && ((ImportTree)parentLeaf).isStatic()) {
                    el = GoToSupport.handleStaticImport(controller, (ImportTree)parentLeaf);
                    insideImportStmt = true;
                } else if (parentLeaf.getKind() == Tree.Kind.PARAMETERIZED_TYPE && parent.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS && ((ParameterizedTypeTree)parentLeaf).getType() == path.getLeaf()) {
                    if (!GoToSupport.isError(controller.getTrees().getElement(parent.getParentPath()))) {
                        path = parent.getParentPath();
                        classType = controller.getTrees().getTypeMirror(path);
                    }
                } else if (path.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION && (classType = controller.getTrees().getTypeMirror(path)) != null && classType.getKind() == TypeKind.DECLARED) {
                    el = controller.getElementUtilities().getDescriptorElement((TypeElement)((DeclaredType)classType).asElement());
                }
                if (el == null) {
                    el = controller.getTrees().getElement(path);
                    if (parentLeaf.getKind() == Tree.Kind.METHOD_INVOCATION && GoToSupport.isError(el)) {
                        List<ExecutableElement> ee = Utilities.fuzzyResolveMethodInvocation(controller, path.getParentPath(), new ArrayList<TypeMirror>(), new int[1]);
                        if (!ee.isEmpty()) {
                            el = ee.iterator().next();
                        } else {
                            ExpressionTree expressionTree = ((MethodInvocationTree)parentLeaf).getMethodSelect();
                            Name methodName = null;
                            switch (expressionTree.getKind()) {
                                case IDENTIFIER: {
                                    Scope s = controller.getTrees().getScope(path);
                                    el = s.getEnclosingClass();
                                    methodName = ((IdentifierTree)expressionTree).getName();
                                    break;
                                }
                                case MEMBER_SELECT: {
                                    el = controller.getTrees().getElement(new TreePath(path, ((MemberSelectTree)expressionTree).getExpression()));
                                    methodName = ((MemberSelectTree)expressionTree).getIdentifier();
                                }
                            }
                            if (el != null) {
                                for (ExecutableElement m : ElementFilter.methodsIn(el.getEnclosedElements())) {
                                    if (m.getSimpleName() != methodName) continue;
                                    el = m;
                                    break;
                                }
                            }
                        }
                    } else if (!tooltip && el != null && el.getKind() == ElementKind.ENUM_CONSTANT && path.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                        Element e = controller.getTrees().getElement(new TreePath(path, ((VariableTree)path.getLeaf()).getInitializer()));
                        if (!controller.getElementUtilities().isSynthetic(e)) {
                            el = e;
                        }
                    }
                    if (el != null && el.getKind() == ElementKind.METHOD) {
                        for (Element element : el.getEnclosingElement().getEnclosedElements()) {
                            if (!element.getKind().name().contains("RECORD_COMPONENT")) continue;
                            try {
                                Class<?> recordComponent = Class.forName("javax.lang.model.element.RecordComponentElement", true, VariableTree.class.getClassLoader());
                                Method getAccessor = recordComponent.getDeclaredMethod("getAccessor", new Class[0]);
                                Method getRecordComponents = TypeElement.class.getDeclaredMethod("getRecordComponents", new Class[0]);
                                for (Element component : (Iterable)getRecordComponents.invoke((Object)element.getEnclosingElement(), new Object[0])) {
                                    if (!Objects.equals(el, getAccessor.invoke((Object)component, new Object[0]))) continue;
                                    el = component;
                                }
                            }
                            catch (ClassNotFoundException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (IllegalAccessException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (IllegalArgumentException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (InvocationTargetException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (NoSuchMethodException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (SecurityException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
            } else {
                return null;
            }
        }
        if (GoToSupport.isError(el)) {
            return null;
        }
        if (goToSource && !insideImportStmt) {
            TypeMirror type = null;
            if (el instanceof VariableElement) {
                type = el.asType();
            }
            if (type != null && type.getKind() == TypeKind.DECLARED) {
                el = ((DeclaredType)type).asElement();
            }
        }
        if (GoToSupport.isError(el)) {
            return null;
        }
        if (controller.getElementUtilities().isSynthetic(el) && el.getKind() == ElementKind.CONSTRUCTOR) {
            el = GoToSupport.handlePossibleAnonymousInnerClass(controller, el);
        }
        if (GoToSupport.isError(el)) {
            return null;
        }
        if (el.getKind() != ElementKind.CONSTRUCTOR && (token[0].id() == JavaTokenId.SUPER || token[0].id() == JavaTokenId.THIS)) {
            return null;
        }
        return new Context(classType, el);
    }

    private static String computeTooltip(CompilationInfo controller, final Document doc, Context resolved, HyperlinkType type) {
        int overridableKind;
        DisplayNameElementVisitor v = new DisplayNameElementVisitor(controller);
        if (resolved.resolved.getKind() == ElementKind.CONSTRUCTOR && resolved.classType != null && resolved.classType.getKind() == TypeKind.DECLARED) {
            v.printExecutable((ExecutableElement)resolved.resolved, (DeclaredType)resolved.classType, true);
        } else {
            v.visit(resolved.resolved, true);
        }
        String result = null;
        try {
            class Ctrl
            implements Callable<Boolean> {
                private volatile boolean cancel;

                Ctrl() {
                }

                @Override
                public Boolean call() throws Exception {
                    return this.cancel;
                }
            }
            Ctrl control = new Ctrl();
            final ElementJavadoc jdoc = ElementJavadoc.create((CompilationInfo)controller, (Element)resolved.resolved, (Callable)control);
            Future text = jdoc != null ? jdoc.getTextAsync() : null;
            String string = result = text != null ? (String)text.get(1L, TimeUnit.SECONDS) : null;
            if (result != null) {
                int idx = 0;
                for (int i = 0; i < 3 && idx >= 0; ++i) {
                    idx = result.indexOf("<p>", idx + 1);
                }
                if (idx >= 0) {
                    result = result.substring(0, idx + 3);
                    result = result + "<a href='***'>" + NbBundle.getMessage(GoToSupport.class, (String)"LBL_More") + "</a>";
                }
                if ((idx = result.indexOf("<p id=\"not-found\">")) >= 0) {
                    result = result.substring(0, idx);
                }
                doc.putProperty("TooltipResolver.hyperlinkListener", new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        String desc;
                        if (e != null && HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && (desc = e.getDescription()) != null) {
                            ElementJavadoc link;
                            ElementJavadoc elementJavadoc = link = "***".contentEquals(desc) ? jdoc : jdoc.resolveLink(desc);
                            if (link != null) {
                                ToolTipSupport tts;
                                JTextComponent comp = EditorRegistry.lastFocusedComponent();
                                if (comp != null && comp.getDocument() == doc && (tts = org.netbeans.editor.Utilities.getEditorUI((JTextComponent)comp).getToolTipSupport()) != null) {
                                    tts.setToolTipVisible(false);
                                }
                                JavaCompletionProvider.JavaCompletionQuery.outerDocumentation.set(new JavaCompletionDoc(link));
                                Completion.get().showDocumentation();
                            }
                        }
                    }
                });
            }
            control.cancel = true;
        }
        catch (Exception control) {
            // empty catch block
        }
        if (result == null || result.isEmpty()) {
            result = v.result.toString();
        }
        if ((overridableKind = GoToSupport.overridableKind(resolved.resolved)) != -1 && type != null) {
            if (type == HyperlinkType.GO_TO_DECLARATION) {
                StringBuilder sb = new StringBuilder();
                sb.append(KeyEvent.getKeyText(org.openide.util.Utilities.isMac() ? 157 : 17)).append('+').append(KeyEvent.getKeyText(18)).append('+');
                result = NbBundle.getMessage(GoToSupport.class, (String)"TP_OverriddenTooltipSugg", (Object)sb.toString(), (Object)overridableKind, (Object)result);
            } else {
                result = NbBundle.getMessage(GoToSupport.class, (String)"TP_GoToOverriddenTooltipSugg", (Object)overridableKind, (Object)result);
            }
        }
        result = "<html><body>" + result;
        return result;
    }

    public static int[] getIdentifierOrLambdaArrowSpan(final Document doc, final int offset, final Token<JavaTokenId>[] token) {
        if (GoToSupport.getFileObject(doc) == null) {
            return null;
        }
        final int[][] ret = new int[][]{null};
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
                if (ts == null) {
                    return;
                }
                ts.move(offset);
                if (!ts.moveNext()) {
                    return;
                }
                Token t = ts.token();
                if (JavaTokenId.JAVADOC_COMMENT == t.id()) {
                    TokenSequence jdts = ts.embedded(JavadocTokenId.language());
                    if (JavadocImports.isInsideReference((TokenSequence)jdts, (int)offset) || JavadocImports.isInsideParamName((TokenSequence)jdts, (int)offset)) {
                        jdts.move(offset);
                        jdts.moveNext();
                        if (jdts.token().id() != JavadocTokenId.OTHER_TEXT) {
                            if (token != null) {
                                token[0] = t;
                            }
                            ret[0] = new int[]{jdts.offset(), jdts.offset() + jdts.token().length()};
                        }
                    }
                    return;
                }
                if (!USABLE_TOKEN_IDS.contains(t.id())) {
                    ts.move(offset - 1);
                    if (!ts.moveNext()) {
                        return;
                    }
                    t = ts.token();
                    if (!USABLE_TOKEN_IDS.contains(t.id())) {
                        return;
                    }
                }
                if (token != null) {
                    token[0] = t;
                }
                ret[0] = new int[]{ts.offset(), ts.offset() + t.length()};
            }
        });
        return ret[0];
    }

    private static Element handlePossibleAnonymousInnerClass(CompilationInfo info, Element el) {
        Element doubleEncl;
        Element encl = el.getEnclosingElement();
        Element element = doubleEncl = encl != null ? encl.getEnclosingElement() : null;
        if (doubleEncl != null && !doubleEncl.getKind().isClass() && !doubleEncl.getKind().isInterface() && doubleEncl.getKind() != ElementKind.PACKAGE && encl.getKind() == ElementKind.CLASS) {
            NewClassTree nct;
            Tree enclTree;
            TreePath enclTreePath = info.getTrees().getPath(encl);
            Tree tree = enclTree = enclTreePath != null ? enclTreePath.getLeaf() : null;
            if (enclTree != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)enclTree.getKind()) && enclTreePath.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS && (nct = (NewClassTree)enclTreePath.getParentPath().getLeaf()).getClassBody() != null) {
                Element parentElement = info.getTrees().getElement(new TreePath(enclTreePath, nct.getIdentifier()));
                if (parentElement == null || parentElement.getKind().isInterface()) {
                    return parentElement;
                }
                TreePath superConstructorCall = (TreePath)new FindSuperConstructorCall().scan(enclTreePath, null);
                if (superConstructorCall != null) {
                    return info.getTrees().getElement(superConstructorCall);
                }
            }
            return null;
        }
        if (encl != null) {
            return encl;
        }
        return el;
    }

    private static Element handleStaticImport(CompilationInfo javac, ImportTree impt) {
        Tree clazz;
        Tree impIdent = impt.getQualifiedIdentifier();
        if (!impt.isStatic() || impIdent == null || impIdent.getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        Trees trees = javac.getTrees();
        MemberSelectTree select = (MemberSelectTree)impIdent;
        Name mName = select.getIdentifier();
        TreePath cutPath = new TreePath(javac.getCompilationUnit());
        TreePath selectPath = new TreePath(new TreePath(cutPath, impt), select.getExpression());
        Element selectElm = trees.getElement(selectPath);
        if (GoToSupport.isError(selectElm)) {
            return null;
        }
        TypeMirror clazzMir = null;
        TreePath clazzPath = null;
        List<? extends Tree> decls = javac.getCompilationUnit().getTypeDecls();
        if (!decls.isEmpty() && TreeUtilities.CLASS_TREE_KINDS.contains((Object)(clazz = decls.get(0)).getKind())) {
            clazzPath = new TreePath(cutPath, clazz);
            Element clazzElm = trees.getElement(clazzPath);
            if (GoToSupport.isError(clazzElm)) {
                return null;
            }
            clazzMir = clazzElm.asType();
        }
        if (clazzMir == null) {
            return null;
        }
        Scope clazzScope = trees.getScope(clazzPath);
        for (Element element : selectElm.getEnclosedElements()) {
            if (!element.getModifiers().contains((Object)Modifier.STATIC) || !mName.contentEquals(element.getSimpleName()) || !trees.isAccessible(clazzScope, element, (DeclaredType)clazzMir)) continue;
            return element;
        }
        return null;
    }

    private static boolean isCaretInsideDeclarationName(CompilationInfo info, Tree t, TreePath path, int caret) {
        try {
            switch (t.getKind()) {
                case INSTANCE_OF: {
                    Tree pattern = TreeShims.getPattern((InstanceOfTree)t);
                    if (pattern == null || !"BINDING_PATTERN".equals(pattern.getKind().name())) {
                        return false;
                    }
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: 
                case METHOD: 
                case VARIABLE: {
                    int[] span = org.netbeans.modules.java.editor.base.semantic.Utilities.findIdentifierSpan((TreePath)path, (CompilationInfo)info, (Document)info.getDocument());
                    if (span == null || span[0] == -1 || span[1] == -1) {
                        return false;
                    }
                    return span[0] <= caret && caret <= span[1];
                }
            }
            return false;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private static int overridableKind(Element el) {
        if (el.getModifiers().contains((Object)Modifier.FINAL) || el.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return -1;
        }
        if (el.getKind().isClass() || el.getKind().isInterface()) {
            return el.getModifiers().contains((Object)Modifier.ABSTRACT) ? 0 : 1;
        }
        if (el.getKind() == ElementKind.METHOD && !el.getModifiers().contains((Object)Modifier.STATIC) && !el.getEnclosingElement().getModifiers().contains((Object)Modifier.FINAL)) {
            return el.getModifiers().contains((Object)Modifier.ABSTRACT) ? 2 : 3;
        }
        return -1;
    }

    private static TreePath adjustPathForModuleName(TreePath path) {
        for (TreePath tp = path; tp != null && (tp.getLeaf().getKind() == Tree.Kind.IDENTIFIER || tp.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT); tp = tp.getParentPath()) {
            Tree parent = tp.getParentPath().getLeaf();
            if (parent.getKind() == Tree.Kind.MODULE && ((ModuleTree)parent).getName() == tp.getLeaf()) {
                return tp.getParentPath();
            }
            if (!(parent.getKind() == Tree.Kind.REQUIRES && ((RequiresTree)parent).getModuleName() == tp.getLeaf() || parent.getKind() == Tree.Kind.EXPORTS && ((ExportsTree)parent).getModuleNames() != null && ((ExportsTree)parent).getModuleNames().contains(tp.getLeaf())) && (parent.getKind() != Tree.Kind.OPENS || ((OpensTree)parent).getModuleNames() == null || !((OpensTree)parent).getModuleNames().contains(tp.getLeaf()))) continue;
            return tp;
        }
        return path;
    }

    private static TreePath getPath(final CompilationInfo info, Element el) {
        final Element toFind = info.getElementUtilities().isSynthetic(el) ? el.getEnclosingElement() : el;
        class S
        extends ErrorAwareTreePathScanner<Void, Void> {
            private TreePath found;

            S() {
            }

            public Void scan(Tree tree, Void p) {
                if (this.found != null) {
                    return null;
                }
                if (tree != null && "BINDING_PATTERN".equals(tree.getKind().name()) && this.process(new TreePath(this.getCurrentPath(), tree))) {
                    return null;
                }
                return (Void)super.scan(tree, (Object)p);
            }

            private boolean process() {
                return this.process(this.getCurrentPath());
            }

            private boolean process(TreePath path) {
                Element resolved = TreeShims.toRecordComponent(info.getTrees().getElement(path));
                if (toFind.equals(resolved)) {
                    this.found = this.getCurrentPath();
                    return true;
                }
                return false;
            }

            public Void visitClass(ClassTree node, Void p) {
                if (!this.process()) {
                    super.visitClass(node, (Object)p);
                }
                return null;
            }

            public Void visitMethod(MethodTree node, Void p) {
                if (!this.process()) {
                    return (Void)super.visitMethod(node, (Object)p);
                }
                return null;
            }

            public Void visitVariable(VariableTree node, Void p) {
                if (!this.process()) {
                    return (Void)super.visitVariable(node, (Object)p);
                }
                return null;
            }

            public Void visitTypeParameter(TypeParameterTree node, Void p) {
                if (!this.process()) {
                    return (Void)super.visitTypeParameter(node, (Object)p);
                }
                return null;
            }
        }
        S search = new S();
        search.scan((Tree)info.getCompilationUnit(), null);
        return search.found;
    }

    private static String getTypeName(CompilationInfo info, TypeMirror t, boolean fqn) {
        return GoToSupport.translate(Utilities.getTypeName(info, t, fqn).toString());
    }

    private static String translate(String input) {
        for (int cntr = 0; cntr < c.length; ++cntr) {
            input = input.replaceAll(c[cntr], tags[cntr]);
        }
        return input;
    }

    public static final class Context {
        public final TypeMirror classType;
        public final Element resolved;

        public Context(TypeMirror classType, Element resolved) {
            this.classType = classType;
            this.resolved = resolved;
        }
    }

    static interface UiUtilsCaller {
        public boolean open(FileObject var1, int var2);

        public void beep(boolean var1, boolean var2);

        public boolean open(ClasspathInfo var1, ElementHandle<?> var2);

        public void warnCannotOpen(String var1);
    }

    private static final class DisplayNameElementVisitor
    extends AbstractElementVisitor9<Void, Boolean> {
        private final CompilationInfo info;
        private StringBuffer result = new StringBuffer();

        public DisplayNameElementVisitor(CompilationInfo info) {
            this.info = info;
        }

        private void boldStartCheck(boolean highlightName) {
            if (highlightName) {
                this.result.append("<b>");
            }
        }

        private void boldStopCheck(boolean highlightName) {
            if (highlightName) {
                this.result.append("</b>");
            }
        }

        @Override
        public Void visitModule(ModuleElement e, Boolean highlightName) {
            this.result.append("module ");
            this.boldStartCheck(highlightName);
            this.result.append(e.getQualifiedName());
            this.boldStopCheck(highlightName);
            return null;
        }

        @Override
        public Void visitPackage(PackageElement e, Boolean highlightName) {
            this.result.append("package ");
            this.boldStartCheck(highlightName);
            this.result.append(e.getQualifiedName());
            this.boldStopCheck(highlightName);
            return null;
        }

        @Override
        public Void visitType(TypeElement e, Boolean highlightName) {
            return this.printType(e, null, highlightName);
        }

        Void printType(TypeElement e, DeclaredType dt, Boolean highlightName) {
            this.modifier(e.getModifiers());
            switch (e.getKind()) {
                case CLASS: {
                    this.result.append("class ");
                    break;
                }
                case INTERFACE: {
                    this.result.append("interface ");
                    break;
                }
                case ENUM: {
                    this.result.append("enum ");
                    break;
                }
                case ANNOTATION_TYPE: {
                    this.result.append("@interface ");
                }
            }
            Element enclosing = e.getEnclosingElement();
            if (enclosing == SourceUtils.getEnclosingTypeElement((Element)e)) {
                this.result.append(((TypeElement)enclosing).getQualifiedName());
                this.result.append('.');
                this.boldStartCheck(highlightName);
                this.result.append(e.getSimpleName());
                this.boldStopCheck(highlightName);
            } else {
                this.result.append(e.getQualifiedName());
            }
            if (dt != null) {
                this.dumpRealTypeArguments(dt.getTypeArguments());
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, Boolean highlightName) {
            this.modifier(e.getModifiers());
            this.result.append(GoToSupport.getTypeName(this.info, e.asType(), true));
            this.result.append(' ');
            this.boldStartCheck(highlightName);
            this.result.append(e.getSimpleName());
            this.boldStopCheck(highlightName);
            if (highlightName.booleanValue()) {
                if (e.getConstantValue() != null) {
                    this.result.append(" = ");
                    this.result.append(StringEscapeUtils.escapeHtml((String)e.getConstantValue().toString()));
                }
                Element enclosing = e.getEnclosingElement();
                if (e.getKind() != ElementKind.PARAMETER && e.getKind() != ElementKind.LOCAL_VARIABLE && e.getKind() != ElementKind.RESOURCE_VARIABLE && e.getKind() != ElementKind.EXCEPTION_PARAMETER && !"BINDING_VARIABLE".equals(e.getKind().name())) {
                    this.result.append(" in ");
                    this.result.append(GoToSupport.getTypeName(this.info, enclosing.asType(), true));
                }
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Boolean highlightName) {
            return this.printExecutable(e, null, highlightName);
        }

        Void printExecutable(ExecutableElement e, DeclaredType dt, Boolean highlightName) {
            switch (e.getKind()) {
                case CONSTRUCTOR: {
                    this.modifier(e.getModifiers());
                    this.dumpTypeArguments(e.getTypeParameters());
                    this.result.append(' ');
                    this.boldStartCheck(highlightName);
                    this.result.append(e.getEnclosingElement().getSimpleName());
                    this.boldStopCheck(highlightName);
                    TypeMirror memberType = null;
                    if (dt != null) {
                        this.dumpRealTypeArguments(dt.getTypeArguments());
                        try {
                            memberType = this.info.getTypes().asMemberOf(dt, e);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    if (memberType instanceof ExecutableType) {
                        this.dumpArguments(e.getParameters(), ((ExecutableType)memberType).getParameterTypes());
                    } else {
                        this.dumpArguments(e.getParameters(), null);
                    }
                    this.dumpThrows(e.getThrownTypes());
                    break;
                }
                case METHOD: {
                    this.modifier(e.getModifiers());
                    this.dumpTypeArguments(e.getTypeParameters());
                    this.result.append(GoToSupport.getTypeName(this.info, e.getReturnType(), true));
                    this.result.append(' ');
                    this.boldStartCheck(highlightName);
                    this.result.append(e.getSimpleName());
                    this.boldStopCheck(highlightName);
                    this.dumpArguments(e.getParameters(), null);
                    this.dumpThrows(e.getThrownTypes());
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Boolean highlightName) {
            return null;
        }

        @Override
        public Void visitUnknown(Element e, Boolean p) {
            if (TreeShims.isRecordComponent(e)) {
                return this.visitVariable((VariableElement)e, p);
            }
            return (Void)super.visitUnknown(e, p);
        }

        private void modifier(Set<Modifier> modifiers) {
            boolean addSpace = false;
            for (Modifier m : modifiers) {
                if (addSpace) {
                    this.result.append(' ');
                }
                addSpace = true;
                this.result.append(m.toString());
            }
            if (addSpace) {
                this.result.append(' ');
            }
        }

        private void dumpTypeArguments(List<? extends TypeParameterElement> list) {
            if (list.isEmpty()) {
                return;
            }
            boolean addSpace = false;
            this.result.append("&lt;");
            for (TypeParameterElement typeParameterElement : list) {
                if (addSpace) {
                    this.result.append(", ");
                }
                this.result.append(GoToSupport.getTypeName(this.info, typeParameterElement.asType(), true));
                addSpace = true;
            }
            this.result.append("&gt;");
        }

        private void dumpRealTypeArguments(List<? extends TypeMirror> list) {
            if (list.isEmpty()) {
                return;
            }
            boolean addSpace = false;
            this.result.append("&lt;");
            for (TypeMirror typeMirror : list) {
                if (addSpace) {
                    this.result.append(", ");
                }
                this.result.append(GoToSupport.getTypeName(this.info, typeMirror, true));
                addSpace = true;
            }
            this.result.append("&gt;");
        }

        private void dumpArguments(List<? extends VariableElement> list, List<? extends TypeMirror> types) {
            Iterator<? extends TypeMirror> typesIt;
            boolean addSpace = false;
            this.result.append('(');
            Iterator<? extends VariableElement> listIt = list.iterator();
            Iterator<? extends TypeMirror> iterator = typesIt = types != null ? types.iterator() : null;
            while (listIt.hasNext()) {
                if (addSpace) {
                    this.result.append(", ");
                }
                VariableElement ve = listIt.next();
                TypeMirror type = typesIt != null ? typesIt.next() : ve.asType();
                this.result.append(GoToSupport.getTypeName(this.info, type, true));
                this.result.append(" ");
                this.result.append(ve.getSimpleName());
                addSpace = true;
            }
            this.result.append(')');
        }

        private void dumpThrows(List<? extends TypeMirror> list) {
            if (list.isEmpty()) {
                return;
            }
            boolean addSpace = false;
            this.result.append(" throws ");
            for (TypeMirror typeMirror : list) {
                if (addSpace) {
                    this.result.append(", ");
                }
                this.result.append(GoToSupport.getTypeName(this.info, typeMirror, true));
                addSpace = true;
            }
        }
    }

    private static final class FindSuperConstructorCall
    extends ErrorAwareTreePathScanner<TreePath, Void> {
        private FindSuperConstructorCall() {
        }

        public TreePath visitMethodInvocation(MethodInvocationTree tree, Void v) {
            if (tree.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals(((IdentifierTree)tree.getMethodSelect()).getName().toString())) {
                return this.getCurrentPath();
            }
            return null;
        }

        public TreePath reduce(TreePath first, TreePath second) {
            if (first == null) {
                return second;
            }
            return first;
        }
    }

    public static final class GoToTarget {
        public final int offsetToOpen;
        public final int endPos;
        public final int[] nameSpan;
        public final ClasspathInfo cpInfo;
        public final ElementHandle elementToOpen;
        public final String resourceName;
        public final String displayNameForError;
        public final boolean success;

        public GoToTarget(int offsetToOpen, int endPos, int[] nameSpan, ClasspathInfo cpInfo, ElementHandle elementToOpen, String resourceName, String displayNameForError, boolean success) {
            this.offsetToOpen = offsetToOpen;
            this.endPos = endPos;
            this.nameSpan = nameSpan;
            this.cpInfo = cpInfo;
            this.elementToOpen = elementToOpen;
            this.resourceName = resourceName;
            this.displayNameForError = displayNameForError;
            this.success = success;
        }
    }
}

