/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web.annotation;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.Refreshable;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.SecurityRoles;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.WebFilter;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.WebServlet;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;

public class AnnotationHelpers {
    private AnnotationModelHelper helper;
    private PersistentObjectManager<WebServlet> webServletsPOM;
    private PersistentObjectManager<WebFilter> webFiltersPOM;
    private PersistentObjectManager<SecurityRoles> securityRolesPOM;

    public AnnotationHelpers(AnnotationModelHelper helper) {
        this.helper = helper;
    }

    public AnnotationModelHelper getHelper() {
        return this.helper;
    }

    public PersistentObjectManager<WebServlet> getWebServletPOM() {
        if (this.webServletsPOM == null) {
            this.webServletsPOM = this.helper.createPersistentObjectManager((ObjectProvider)new AnnotationProvider("javax.servlet.annotation.WebServlet"){

                WebServlet newItem(AnnotationModelHelper helper, TypeElement typeElement) {
                    return new WebServlet(helper, typeElement);
                }
            });
        }
        return this.webServletsPOM;
    }

    public PersistentObjectManager<WebFilter> getWebFilterPOM() {
        if (this.webFiltersPOM == null) {
            this.webFiltersPOM = this.helper.createPersistentObjectManager((ObjectProvider)new AnnotationProvider("javax.servlet.annotation.WebFilter"){

                WebFilter newItem(AnnotationModelHelper helper, TypeElement typeElement) {
                    return new WebFilter(helper, typeElement);
                }
            });
        }
        return this.webFiltersPOM;
    }

    public PersistentObjectManager<SecurityRoles> getSecurityRolesPOM() {
        if (this.securityRolesPOM == null) {
            this.securityRolesPOM = this.helper.createPersistentObjectManager((ObjectProvider)new AnnotationProvider("javax.annotation.security.DeclareRoles"){

                SecurityRoles newItem(AnnotationModelHelper helper, TypeElement typeElement) {
                    return new SecurityRoles(helper, typeElement);
                }
            });
        }
        return this.securityRolesPOM;
    }

    private abstract class AnnotationProvider<T extends Refreshable>
    implements ObjectProvider<T> {
        private String annotationName;

        AnnotationProvider(String annotationName) {
            this.annotationName = annotationName;
        }

        public List<T> createInitialObjects() throws InterruptedException {
            final ArrayList result = new ArrayList();
            AnnotationHelpers.this.helper.getAnnotationScanner().findAnnotations(this.annotationName, AnnotationScanner.TYPE_KINDS, new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    result.add(AnnotationProvider.this.newItem(AnnotationHelpers.this.helper, type));
                }
            });
            return result;
        }

        public List<T> createObjects(TypeElement type) {
            ArrayList<T> result = new ArrayList<T>();
            if (AnnotationHelpers.this.helper.hasAnnotation(type.getAnnotationMirrors(), this.annotationName)) {
                result.add(this.newItem(AnnotationHelpers.this.helper, type));
            }
            return result;
        }

        public boolean modifyObjects(TypeElement type, List<T> objects) {
            assert (objects.size() == 1);
            Refreshable item = (Refreshable)objects.get(0);
            if (!item.refresh(type)) {
                objects.remove(0);
                return true;
            }
            return false;
        }

        abstract T newItem(AnnotationModelHelper var1, TypeElement var2);
    }
}

