/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.jstesting;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProviderHelper;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.web.clientproject.api.jstesting.Coverage;
import org.netbeans.modules.web.clientproject.api.jstesting.FileCoverageDetailsImpl;
import org.netbeans.modules.web.clientproject.spi.jstesting.CoverageImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class CoverageProviderImpl
implements CoverageProvider,
CoverageImplementation {
    private static final Logger LOGGER = Logger.getLogger(CoverageProviderImpl.class.getName());
    private static final Set<String> MIME_TYPES = Collections.singleton("text/javascript");
    private final Project project;
    private final Map<String, Coverage.File> files = new ConcurrentHashMap<String, Coverage.File>();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Boolean enabled = null;

    public CoverageProviderImpl(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return false;
    }

    public boolean isAggregating() {
        throw new IllegalStateException("Aggregating is not supported");
    }

    public void setAggregating(boolean aggregating) {
        throw new IllegalStateException("Aggregating is not supported");
    }

    public Set<String> getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public synchronized boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = CoverageProviderHelper.isEnabled((Project)this.project);
            CoverageManager.INSTANCE.setEnabled(this.project, this.enabled.booleanValue());
        }
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean on) {
        CoverageProviderImpl coverageProviderImpl = this;
        synchronized (coverageProviderImpl) {
            if (this.enabled != null && on == this.enabled) {
                return;
            }
            this.enabled = on;
        }
        CoverageProviderHelper.setEnabled((Project)this.project, (boolean)on);
        this.propertyChangeSupport.firePropertyChange("ENABLED", !on, on);
    }

    public void clear() {
        this.files.clear();
    }

    public FileCoverageDetails getDetails(FileObject fo, Document doc) {
        Coverage.File file = this.files.get(FileUtil.toFile((FileObject)fo).getAbsolutePath());
        if (file == null) {
            return null;
        }
        return new FileCoverageDetailsImpl(fo, file);
    }

    public List<FileCoverageSummary> getResults() {
        Collection<Coverage.File> allFiles = this.files.values();
        ArrayList<FileCoverageSummary> result = new ArrayList<FileCoverageSummary>(allFiles.size());
        for (Coverage.File file : allFiles) {
            result.add(CoverageProviderImpl.getFileCoverageSummary(file));
        }
        return result;
    }

    public String getTestAllAction() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFiles(List<Coverage.File> files) {
        assert (files != null);
        Map<String, Coverage.File> map = this.files;
        synchronized (map) {
            this.files.clear();
            for (Coverage.File file : files) {
                this.files.put(file.getPath(), file);
            }
        }
        CoverageManager.INSTANCE.resultsUpdated(this.project, (CoverageProvider)this);
    }

    static FileCoverageSummary getFileCoverageSummary(Coverage.File file) {
        assert (file != null);
        FileObject fo = FileUtil.toFileObject((File)new File(file.getPath()));
        return new FileCoverageSummary(fo, fo.getNameExt(), file.getMetrics().getStatements(), file.getMetrics().getCoveredStatements(), -1, -1);
    }
}

