/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.struts;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.struts.ActionServletAwareProcessor;

@Deprecated
public class ContextLoaderPlugIn
implements PlugIn {
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    public static final Class DEFAULT_CONTEXT_CLASS = XmlWebApplicationContext.class;
    public static final String SERVLET_CONTEXT_PREFIX = ContextLoaderPlugIn.class.getName() + ".CONTEXT.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private ActionServlet actionServlet;
    private ModuleConfig moduleConfig;
    private WebApplicationContext webApplicationContext;

    public void setContextClassName(String contextClassName) throws ClassNotFoundException {
        this.contextClass = ClassUtils.forName((String)contextClassName);
    }

    public void setContextClass(Class contextClass) {
        this.contextClass = contextClass;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        if (this.actionServlet != null) {
            return this.actionServlet.getServletName() + DEFAULT_NAMESPACE_SUFFIX;
        }
        return null;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public final void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        long startTime = System.currentTimeMillis();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ContextLoaderPlugIn for Struts ActionServlet '" + actionServlet.getServletName() + ", module '" + moduleConfig.getPrefix() + "': initialization started"));
        }
        this.actionServlet = actionServlet;
        this.moduleConfig = moduleConfig;
        try {
            this.webApplicationContext = this.initWebApplicationContext();
            this.onInit();
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        if (this.logger.isInfoEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.info((Object)("ContextLoaderPlugIn for Struts ActionServlet '" + actionServlet.getServletName() + "', module '" + moduleConfig.getPrefix() + "': initialization completed in " + elapsedTime + " ms"));
        }
    }

    public final ActionServlet getActionServlet() {
        return this.actionServlet;
    }

    public final String getServletName() {
        return this.actionServlet.getServletName();
    }

    public final ServletContext getServletContext() {
        return this.actionServlet.getServletContext();
    }

    public final ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public final String getModulePrefix() {
        return this.moduleConfig.getPrefix();
    }

    protected WebApplicationContext initWebApplicationContext() throws BeansException, IllegalStateException {
        this.getServletContext().log("Initializing WebApplicationContext for Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "'");
        WebApplicationContext parent = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        WebApplicationContext wac = this.createWebApplicationContext(parent);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Using context class '" + wac.getClass().getName() + "' for servlet '" + this.getServletName() + "'"));
        }
        String attrName = this.getServletContextAttributeName();
        this.getServletContext().setAttribute(attrName, (Object)wac);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Published WebApplicationContext of Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "' as ServletContext attribute with name [" + attrName + "]"));
        }
        return wac;
    }

    protected WebApplicationContext createWebApplicationContext(WebApplicationContext parent) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ContextLoaderPlugIn for Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "' will try to create custom WebApplicationContext " + "context of class '" + this.getContextClass().getName() + "', using parent context [" + parent + "]"));
        }
        if (!ConfigurableWebApplicationContext.class.isAssignableFrom(this.getContextClass())) {
            throw new ApplicationContextException("Fatal initialization error in ContextLoaderPlugIn for Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "': custom WebApplicationContext class [" + this.getContextClass().getName() + "] is not of type ConfigurableWebApplicationContext");
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass((Class)this.getContextClass());
        wac.setParent((ApplicationContext)parent);
        wac.setServletContext(this.getServletContext());
        wac.setNamespace(this.getNamespace());
        if (this.getContextConfigLocation() != null) {
            wac.setConfigLocations(StringUtils.tokenizeToStringArray((String)this.getContextConfigLocation(), (String)",; \t\n"));
        }
        wac.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
                beanFactory.addBeanPostProcessor((BeanPostProcessor)new ActionServletAwareProcessor(ContextLoaderPlugIn.this.getActionServlet()));
                beanFactory.ignoreDependencyType(ActionServlet.class);
            }
        });
        wac.refresh();
        return wac;
    }

    public String getServletContextAttributeName() {
        return SERVLET_CONTEXT_PREFIX + this.getModulePrefix();
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected void onInit() throws ServletException {
    }

    public void destroy() {
        this.getServletContext().log("Closing WebApplicationContext of Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "'");
        if (this.getWebApplicationContext() instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.getWebApplicationContext()).close();
        }
    }
}

