/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory2;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraInstanceProvider;
import org.netbeans.modules.payara.jakartaee.Hk2Configuration;
import org.netbeans.modules.payara.jakartaee.Hk2DeploymentFactory;
import org.netbeans.modules.payara.jakartaee.Hk2DeploymentManager;
import org.netbeans.modules.payara.jakartaee.ModuleConfigurationImpl;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersion;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;

abstract class AbstractHk2ConfigurationFactory
implements ModuleConfigurationFactory2 {
    private final Hk2DeploymentManager hk2dm;

    AbstractHk2ConfigurationFactory(Hk2DeploymentManager hk2dm) {
        this.hk2dm = hk2dm;
    }

    public ModuleConfiguration create(J2eeModule module) throws ConfigurationException {
        ModuleConfigurationImpl retVal = null;
        try {
            retVal = new ModuleConfigurationImpl(module, new Hk2Configuration(module, PayaraPlatformVersion.getLatestVersion()), this.hk2dm);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new ConfigurationException(module.toString(), (Throwable)ex);
        }
        return retVal;
    }

    public ModuleConfiguration create(@NonNull J2eeModule module, @NonNull String instanceUrl) throws ConfigurationException {
        ModuleConfigurationImpl retVal = null;
        PayaraInstance instance = PayaraInstanceProvider.getProvider().getPayaraInstance(instanceUrl);
        PayaraPlatformVersionAPI version = instance != null ? instance.getPlatformVersion() : null;
        try {
            Hk2DeploymentManager dm = this.hk2dm != null ? this.hk2dm : (Hk2DeploymentManager)Hk2DeploymentFactory.createEe(version).getDisconnectedDeploymentManager(instanceUrl);
            retVal = new ModuleConfigurationImpl(module, new Hk2Configuration(module, version), dm);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new ConfigurationException(module.toString(), (Throwable)ex);
        }
        return retVal;
    }
}

