/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.spi;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.jersey.spi.Contract;

@Priority(value=4000)
@Contract
public abstract class ContentEncoder
implements ReaderInterceptor,
WriterInterceptor {
    private final Set<String> supportedEncodings;

    protected ContentEncoder(String ... supportedEncodings) {
        if (supportedEncodings.length == 0) {
            throw new IllegalArgumentException();
        }
        this.supportedEncodings = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(supportedEncodings)));
    }

    public final Set<String> getSupportedEncodings() {
        return this.supportedEncodings;
    }

    public abstract InputStream decode(String var1, InputStream var2) throws IOException;

    public abstract OutputStream encode(String var1, OutputStream var2) throws IOException;

    public final Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        String contentEncoding = (String)context.getHeaders().getFirst((Object)"Content-Encoding");
        if (contentEncoding != null && this.getSupportedEncodings().contains(contentEncoding)) {
            context.setInputStream(this.decode(contentEncoding, context.getInputStream()));
        }
        return context.proceed();
    }

    public final void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        String contentEncoding = (String)context.getHeaders().getFirst((Object)"Content-Encoding");
        if (contentEncoding != null && this.getSupportedEncodings().contains(contentEncoding)) {
            context.setOutputStream(this.encode(contentEncoding, context.getOutputStream()));
        }
        context.proceed();
    }
}

