/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.angular.index.AngularJsController;
import org.netbeans.modules.html.angular.index.AngularJsIndexer;
import org.netbeans.modules.html.angular.model.AngularConfigInterceptor;
import org.netbeans.modules.html.angular.model.ModelUtils;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.JsArray;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.spi.FunctionArgument;
import org.netbeans.modules.javascript2.model.spi.FunctionInterceptor;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class AngularModuleInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("(.)*\\.controller");
    private static final List<String> KNOWN_TYPES = Arrays.asList("Array", "Boolean", "Function", "null", "Number", "Object", "RegExp", "String", "undefined", "unresolved");
    private static final String ROUTECONFIG_PROP = "$routeConfig";

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public Collection<TypeUsage> intercept(Snapshot snapshot, String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        FileObject fo;
        JsObject controllerDecl;
        if (!AngularJsIndexer.isScannerThread()) {
            return Collections.emptyList();
        }
        String controllerName = null;
        String functionName = null;
        int functionOffset = -1;
        int nameOffset = -1;
        HashMap<String, Integer> controllersMap = null;
        for (FunctionArgument fArgument : args) {
            block0 : switch (fArgument.getKind()) {
                case STRING: {
                    if (controllerName != null) break;
                    controllerName = (String)fArgument.getValue();
                    nameOffset = fArgument.getOffset();
                    break;
                }
                case ARRAY: {
                    JsArray array = (JsArray)fArgument.getValue();
                    for (TypeUsage type : array.getTypesInArray()) {
                        if (type.getType().equals("Function")) {
                            functionName = type.getType();
                            functionOffset = type.getOffset();
                            break block0;
                        }
                        if (KNOWN_TYPES.contains(type.getType())) continue;
                        String[] parts = type.getType().split("\\.");
                        JsObject property = globalObject;
                        for (int i = 0; i < parts.length && (property = property.getProperty(parts[i])) != null; ++i) {
                        }
                        if (property == null) continue;
                        functionName = property.getFullyQualifiedName();
                        functionOffset = property.getOffset();
                    }
                    break;
                }
                case REFERENCE: {
                    List fArgumentValue = (List)fArgument.getValue();
                    String string = functionName = fArgumentValue.isEmpty() ? null : (String)fArgumentValue.get(0);
                    if (functionName != null) {
                        JsObject argumentObject;
                        JsFunction func;
                        JsObject funcObj = globalObject.getProperty(functionName);
                        JsFunction jsFunction = func = funcObj != null && funcObj instanceof JsFunction ? (JsFunction)funcObj : null;
                        if (func == null && (argumentObject = ModelUtils.findJsObject(globalObject, fArgument.getOffset())) != null && argumentObject instanceof JsFunction) {
                            JsFunction iife = (JsFunction)argumentObject;
                            funcObj = iife.getProperty(functionName);
                            JsFunction jsFunction2 = func = funcObj != null && funcObj instanceof JsFunction ? (JsFunction)iife.getProperty(functionName) : null;
                        }
                        if (func != null && !func.isAnonymous()) {
                            functionOffset = func.getOffset();
                            break;
                        }
                    }
                    functionOffset = fArgument.getOffset();
                    break;
                }
                case ANONYMOUS_OBJECT: {
                    JsObject object = (JsObject)fArgument.getValue();
                    controllersMap = new HashMap<String, Integer>();
                    functionOffset = object.getOffset();
                    for (Map.Entry prop : object.getProperties().entrySet()) {
                        if (!(prop.getValue() instanceof JsFunction)) continue;
                        controllersMap.put(((JsObject)prop.getValue()).getName(), ((JsFunction)prop.getValue()).getOffset());
                    }
                    break;
                }
            }
            if ((controllerName == null || functionName == null) && (controllerName != null || controllersMap == null)) continue;
            break;
        }
        if (controllerName != null && functionName != null) {
            JsObject functProp;
            controllerDecl = ModelUtils.findJsObject(globalObject, functionOffset);
            if (controllerDecl != null && !functionName.equals("Function") && !controllerDecl.getFullyQualifiedName().endsWith(functionName) && (functProp = controllerDecl.getProperty(functionName)) != null && functProp.getFullyQualifiedName().endsWith(functionName)) {
                controllerDecl = functProp;
            }
            if (controllerDecl != null && controllerDecl instanceof JsFunction && controllerDecl.isDeclared()) {
                String fqnOfController = controllerDecl.getFullyQualifiedName();
                fo = globalObject.getFileObject();
                if (fo != null) {
                    AngularJsIndexer.addController(fo.toURI(), new AngularJsController(controllerName, fqnOfController, fo.toURL(), nameOffset));
                }
                this.indexComponents(snapshot, fo, controllerDecl);
            }
        } else if (controllerName == null && controllersMap != null && (controllerDecl = ModelUtils.findJsObject(globalObject, functionOffset)) != null && controllerDecl instanceof JsObject && controllerDecl.isDeclared()) {
            fo = globalObject.getFileObject();
            for (Map.Entry controller : controllersMap.entrySet()) {
                String fqnOfController = controllerDecl.getFullyQualifiedName() + "." + (String)controller.getKey();
                if (fo == null) continue;
                AngularJsIndexer.addController(fo.toURI(), new AngularJsController((String)controller.getKey(), fqnOfController, fo.toURL(), (Integer)controller.getValue()));
            }
        }
        return Collections.emptyList();
    }

    private void indexComponents(Snapshot snapshot, FileObject fo, JsObject controllerDecl) {
        int routerConfigOffset;
        TokenSequence ts;
        Collection assignments;
        JsObject routerConfig = controllerDecl.getProperty(ROUTECONFIG_PROP);
        if (routerConfig != null && routerConfig instanceof JsArray && (assignments = routerConfig.getAssignments()).size() == 1 && ((TypeUsage)assignments.iterator().next()).getType().equals("Array") && (ts = LexUtilities.getJsTokenSequence((Snapshot)snapshot, (int)(routerConfigOffset = routerConfig.getOffset()))) != null && fo != null) {
            AngularConfigInterceptor.saveComponentsToIndex(fo, AngularConfigInterceptor.findComponents((TokenSequence<? extends JsTokenId>)ts, routerConfigOffset));
        }
    }
}

