/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.indexer.api.Bundle;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class RepositoryPreferences {
    private static final Logger LOG = Logger.getLogger(RepositoryPreferences.class.getName());
    private static RepositoryPreferences instance;
    private static final String KEY_DISPLAY_NAME = "name";
    private static final String KEY_PATH = "path";
    private static final String KEY_INDEX_URL = "index";
    private static final String KEY_REPO_URL = "url";
    public static final String PROP_INDEX_FREQ = "indexUpdateFrequency";
    public static final String PROP_INDEX = "createIndex";
    public static final String PROP_LAST_INDEX_UPDATE = "lastIndexUpdate";
    public static final int FREQ_ONCE_WEEK = 0;
    public static final int FREQ_ONCE_DAY = 1;
    public static final int FREQ_STARTUP = 2;
    public static final int FREQ_NEVER = 3;
    private final Map<String, RepositoryInfo> infoCache = new HashMap<String, RepositoryInfo>();
    private final Map<Object, List<RepositoryInfo>> transients = new LinkedHashMap<Object, List<RepositoryInfo>>();
    private RepositoryInfo local;
    private final RepositoryInfo central;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    private RepositoryPreferences() {
        try {
            this.central = new RepositoryInfo("central", "central", null, "https://repo.maven.apache.org/maven2");
            this.central.setMirrorStrategy(RepositoryInfo.MirrorStrategy.ALL);
        }
        catch (URISyntaxException x) {
            throw new AssertionError((Object)x);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/maven/nexus/indexing");
    }

    private static Preferences storage() {
        return NbPreferences.root().node("org/netbeans/modules/maven/repositories");
    }

    public static synchronized RepositoryPreferences getInstance() {
        if (instance == null) {
            instance = new RepositoryPreferences();
        }
        return instance;
    }

    @CheckForNull
    private static RepositoryInfo createRepositoryInfo(Preferences p) throws URISyntaxException {
        String id = p.name();
        String name = p.get(KEY_DISPLAY_NAME, null);
        if (name == null) {
            return null;
        }
        String path = p.get(KEY_PATH, null);
        String repourl = p.get(KEY_REPO_URL, null);
        String indexurl = p.get(KEY_INDEX_URL, null);
        RepositoryInfo repo = new RepositoryInfo(id, name, path, repourl, indexurl);
        repo.setMirrorStrategy(RepositoryInfo.MirrorStrategy.NON_WILDCARD);
        return repo;
    }

    @NonNull
    public synchronized RepositoryInfo getLocalRepository() {
        if (this.local == null) {
            try {
                this.local = new RepositoryInfo("local", Bundle.local(), EmbedderFactory.getProjectEmbedder().getLocalRepositoryFile().getAbsolutePath(), null);
                this.local.setMirrorStrategy(RepositoryInfo.MirrorStrategy.NONE);
            }
            catch (URISyntaxException x) {
                throw new AssertionError((Object)x);
            }
        }
        return this.local;
    }

    @CheckForNull
    public RepositoryInfo getRepositoryInfoById(String id) {
        List<RepositoryInfo> infos = this.getRepositoryInfos();
        for (RepositoryInfo ri : infos) {
            if (!ri.getId().equals(id)) continue;
            return ri;
        }
        for (RepositoryInfo ri : infos) {
            if (!ri.isMirror()) continue;
            for (RepositoryInfo rii : ri.getMirroredRepositories()) {
                if (!rii.getId().equals(id)) continue;
                return ri;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryInfo> getRepositoryInfos() {
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>();
        toRet.add(this.getLocalRepository());
        HashSet<String> ids = new HashSet<String>();
        ids.add("local");
        HashSet<String> urls = new HashSet<String>();
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            Preferences storage = RepositoryPreferences.storage();
            try {
                HashSet<String> gone = new HashSet<String>(this.infoCache.keySet());
                for (String c : storage.childrenNames()) {
                    RepositoryInfo ri = this.infoCache.get(c);
                    if (ri == null) {
                        Preferences child = storage.node(c);
                        try {
                            ri = RepositoryPreferences.createRepositoryInfo(child);
                            if (ri == null) continue;
                            this.infoCache.put(c, ri);
                        }
                        catch (Exception x) {
                            LOG.log(Level.INFO, c, x);
                            try {
                                child.removeNode();
                            }
                            catch (BackingStoreException x2) {
                                LOG.log(Level.INFO, null, x2);
                            }
                            continue;
                        }
                    }
                    toRet.add(ri);
                    gone.remove(c);
                    ids.add(ri.getId());
                    urls.add(ri.getRepositoryUrl());
                }
                for (String g : gone) {
                    this.infoCache.remove(g);
                }
            }
            catch (BackingStoreException x) {
                LOG.log(Level.INFO, null, x);
            }
            if (this.transients.isEmpty()) {
                if (ids.add(this.central.getId()) && urls.add(this.central.getRepositoryUrl())) {
                    toRet.add(this.central);
                }
            } else {
                for (List<RepositoryInfo> infos : this.transients.values()) {
                    for (RepositoryInfo info : infos) {
                        if (!ids.add(info.getId()) || !urls.add(info.getRepositoryUrl())) continue;
                        toRet.add(info);
                    }
                }
            }
        }
        MavenEmbedder embedder2 = EmbedderFactory.getOnlineEmbedder();
        DefaultMirrorSelector selectorWithGroups = new DefaultMirrorSelector();
        DefaultMirrorSelector selectorWithoutGroups = new DefaultMirrorSelector();
        Settings settings = embedder2.getSettings();
        for (Mirror mirror : settings.getMirrors()) {
            String mirrorOf = mirror.getMirrorOf();
            selectorWithGroups.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirrorOf, mirror.getMirrorOfLayouts());
            if (mirrorOf.contains("*")) continue;
            selectorWithoutGroups.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirrorOf, mirror.getMirrorOfLayouts());
        }
        ArrayList<RepositoryInfo> semiTreed = new ArrayList<RepositoryInfo>();
        for (RepositoryInfo in : toRet) {
            if (in.getMirrorStrategy() == RepositoryInfo.MirrorStrategy.ALL || in.getMirrorStrategy() == RepositoryInfo.MirrorStrategy.NON_WILDCARD) {
                int index;
                RepositoryInfo processed = this.getMirrorInfo(in, (MirrorSelector)(in.getMirrorStrategy() == RepositoryInfo.MirrorStrategy.ALL ? selectorWithGroups : selectorWithoutGroups), settings);
                boolean isMirror = true;
                if (processed == null) {
                    isMirror = false;
                    processed = in;
                }
                if ((index = semiTreed.indexOf(processed)) > -1) {
                    processed = (RepositoryInfo)semiTreed.get(index);
                } else {
                    semiTreed.add(processed);
                }
                if (!isMirror) continue;
                processed.addMirrorOfRepository(in);
                continue;
            }
            semiTreed.add(in);
        }
        return semiTreed;
    }

    private RepositoryInfo getMirrorInfo(RepositoryInfo info, MirrorSelector selector, Settings settings) {
        RemoteRepository original = new RemoteRepository.Builder(info.getId(), "default", info.getRepositoryUrl()).build();
        RemoteRepository mirror = selector.getMirror(original);
        if (mirror != null) {
            try {
                String name = mirror.getId();
                for (Mirror m : settings.getMirrors()) {
                    if (m.getId() == null || !m.getId().equals(mirror.getId())) continue;
                    name = m.getName();
                    break;
                }
                RepositoryInfo toret = new RepositoryInfo(mirror.getId(), name, null, mirror.getUrl());
                toret.setMirrorStrategy(RepositoryInfo.MirrorStrategy.NONE);
                return toret;
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrModifyRepositoryInfo(RepositoryInfo info) {
        String id = info.getId();
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            this.infoCache.put(id, info);
            Preferences p = RepositoryPreferences.storage().node(id);
            p.put(KEY_DISPLAY_NAME, info.getName());
            RepositoryPreferences.put(p, KEY_PATH, info.getRepositoryPath());
            RepositoryPreferences.put(p, KEY_REPO_URL, info.getRepositoryUrl());
            if (info.getRepositoryUrl() != null) {
                RepositoryPreferences.put(p, KEY_INDEX_URL, info.getIndexUpdateUrl().equals(info.getRepositoryUrl() + ".index/") ? null : info.getIndexUpdateUrl());
            }
        }
        this.cs.fireChange();
    }

    private static void put(@NonNull Preferences p, @NonNull String key, @NullAllowed String value) {
        if (value != null) {
            p.put(key, value);
        } else {
            p.remove(key);
        }
    }

    public boolean isPersistent(String id) {
        return RepositoryPreferences.storage().node(id).get(KEY_DISPLAY_NAME, null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryInfo(RepositoryInfo info) {
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            String id = info.getId();
            this.infoCache.remove(id);
            try {
                RepositoryPreferences.storage().node(id).removeNode();
            }
            catch (BackingStoreException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        this.cs.fireChange();
    }

    public static void setIndexUpdateFrequency(int fr) {
        RepositoryPreferences.getPreferences().putInt(PROP_INDEX_FREQ, fr);
    }

    public static int getIndexUpdateFrequency() {
        int defaultFrequency = Boolean.getBoolean("netbeans.full.hack") ? 3 : RepositoryPreferences.getDefaultIndexUpdateFrequency();
        return RepositoryPreferences.getPreferences().getInt(PROP_INDEX_FREQ, defaultFrequency);
    }

    static int getDefaultIndexUpdateFrequency() throws NumberFormatException {
        return Integer.parseInt(Bundle.DEFAULT_UPDATE_FREQ());
    }

    public static void setIndexRepositories(boolean bool) {
        RepositoryPreferences.getPreferences().putBoolean(PROP_INDEX, bool);
    }

    public static boolean isIndexRepositories() {
        return RepositoryPreferences.getPreferences().getBoolean(PROP_INDEX, RepositoryPreferences.getDefaultIndexRepositories());
    }

    static boolean getDefaultIndexRepositories() {
        return Boolean.valueOf(Bundle.DEFAULT_CREATE_INDEX());
    }

    public static Date getLastIndexUpdate(String repoId) {
        long old;
        if (repoId.contains("//")) {
            repoId = repoId.replace("//", "_");
            LOG.log(Level.FINE, "Getting last index update: Repo''s id contains consecutive slashes, replacing them with '_': {0}", repoId);
        }
        if ((old = RepositoryPreferences.getPreferences().getLong("lastIndexUpdate." + repoId, 0L)) != 0L) {
            RepositoryPreferences.getPreferences().remove("lastIndexUpdate." + repoId);
            RepositoryPreferences.storage().node(repoId).putLong(PROP_LAST_INDEX_UPDATE, old);
        }
        return new Date(RepositoryPreferences.storage().node(repoId).getLong(PROP_LAST_INDEX_UPDATE, 0L));
    }

    public static void setLastIndexUpdate(String repoId, Date date) {
        if (repoId.contains("//")) {
            repoId = repoId.replace("//", "_");
            LOG.log(Level.FINE, "Setting last index update: Repo''s id contains consecutive slashes, replacing them with '_': {0}", repoId);
        }
        RepositoryPreferences.getPreferences().remove("lastIndexUpdate." + repoId);
        RepositoryPreferences.storage().node(repoId).putLong(PROP_LAST_INDEX_UPDATE, date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransientRepository(Object key, String id, String displayName, String url, RepositoryInfo.MirrorStrategy strategy) throws URISyntaxException {
        if (id.contains("//")) {
            id = id.replace("//", "_");
            LOG.log(Level.FINE, "Adding transient repository: Repo''s id contains consecutive slashes, replacing them with '_': {0}", id);
        }
        if (!(url.startsWith("http://") || url.startsWith("https://") || url.startsWith("file:"))) {
            return;
        }
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            List<RepositoryInfo> infos = this.transients.get(key);
            if (infos == null) {
                infos = new ArrayList<RepositoryInfo>();
                this.transients.put(key, infos);
            }
            RepositoryInfo info = new RepositoryInfo(id, displayName, null, url);
            info.setMirrorStrategy(strategy);
            infos.add(info);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransientRepositories(Object key) {
        Map<String, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            this.transients.remove(key);
        }
        this.cs.fireChange();
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    public List<ArtifactRepository> remoteRepositories(MavenEmbedder embedder) {
        ArrayList<ArtifactRepository> remotes = new ArrayList<ArtifactRepository>();
        for (RepositoryInfo info : this.getRepositoryInfos()) {
            if (info.isLocal()) continue;
            remotes.add(embedder.createRemoteRepository(info.getRepositoryUrl(), info.getId()));
        }
        return remotes;
    }
}

