/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.Bundle;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.browser.ui.picker.BrowserCombo;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

public final class BrowserUISupport {
    private static final Logger LOGGER = Logger.getLogger(BrowserUISupport.class.getName());

    private BrowserUISupport() {
    }

    public static BrowserComboBoxModel createBrowserModel(@NullAllowed String selectedBrowserId, boolean showIDEGlobalBrowserOption) {
        return BrowserUISupport.createBrowserModel(selectedBrowserId, showIDEGlobalBrowserOption, false);
    }

    public static BrowserComboBoxModel createBrowserModel(@NullAllowed String selectedBrowserId, boolean showIDEGlobalBrowserOption, boolean includePhoneGap) {
        List<WebBrowser> browsers = WebBrowsers.getInstance().getAll(false, showIDEGlobalBrowserOption, includePhoneGap, true);
        if (selectedBrowserId == null) {
            selectedBrowserId = BrowserUISupport.getDefaultBrowserChoice(showIDEGlobalBrowserOption).getId();
        }
        return BrowserUISupport.createBrowserModel(selectedBrowserId, browsers);
    }

    public static BrowserComboBoxModel createBrowserModel(@NullAllowed String selectedBrowserId, List<WebBrowser> browsers) {
        Parameters.notNull((CharSequence)"browsers", browsers);
        BrowserComboBoxModel model = new BrowserComboBoxModel(browsers);
        for (int i = 0; i < model.getSize(); ++i) {
            WebBrowser browser = model.getElementAt(i);
            assert (browser != null);
            if (!browser.getId().equals(selectedBrowserId)) continue;
            model.setSelectedItem(browser);
            break;
        }
        return model;
    }

    public static ListCellRenderer<WebBrowser> createBrowserRenderer() {
        return new BrowserRenderer();
    }

    public static WebBrowser getDefaultBrowserChoice(boolean isIDEGlobalBrowserValidOption) {
        if (isIDEGlobalBrowserValidOption) {
            return BrowserUISupport.findWebBrowserById(BrowserUISupport.getDefaultBrowserId());
        }
        BrowserFamilyId preferredBrowser = WebBrowsers.getIDEOptionsBrowserFamily();
        List<WebBrowser> browsers = WebBrowsers.getInstance().getAll(false, false, true, true);
        for (WebBrowser bw : browsers) {
            if (bw.getBrowserFamily() != preferredBrowser || !bw.hasNetBeansIntegration()) continue;
            return bw;
        }
        for (WebBrowser bw : browsers) {
            if (bw.getBrowserFamily() == BrowserFamilyId.CHROME && bw.hasNetBeansIntegration()) {
                return bw;
            }
            if (bw.getBrowserFamily() != BrowserFamilyId.CHROMIUM || !bw.hasNetBeansIntegration()) continue;
            return bw;
        }
        assert (!browsers.isEmpty());
        return browsers.get(0);
    }

    public static String getLongDisplayName(WebBrowser browser) {
        String name = browser.getName();
        switch (browser.getBrowserFamily()) {
            case JAVAFX_WEBVIEW: {
                return name;
            }
        }
        if (browser.hasNetBeansIntegration()) {
            return Bundle.BrowserUISupport_browser_name_integrated(name);
        }
        return name;
    }

    private static String getDefaultBrowserId() {
        return "default";
    }

    @CheckForNull
    public static WebBrowser getBrowser(@NonNull String browserId) {
        assert (browserId != null);
        return BrowserUISupport.findWebBrowserById(browserId);
    }

    public static JComboBox createBrowserPickerComboBox(@NullAllowed String selectedBrowserId, boolean showIDEGlobalBrowserOption, boolean includePhoneGap, ComboBoxModel model) {
        return new BrowserCombo(selectedBrowserId, showIDEGlobalBrowserOption, includePhoneGap, model);
    }

    public static JComboBox createBrowserPickerComboBox(@NullAllowed String selectedBrowserId, boolean showIDEGlobalBrowserOption, boolean includePhoneGap) {
        return BrowserUISupport.createBrowserPickerComboBox(selectedBrowserId, showIDEGlobalBrowserOption, includePhoneGap, BrowserUISupport.createBrowserModel(selectedBrowserId, showIDEGlobalBrowserOption, includePhoneGap));
    }

    private static WebBrowser findWebBrowserById(String id) {
        for (WebBrowser wb : WebBrowsers.getInstance().getAll(false, true, true, false)) {
            if (!wb.getId().equals(id)) continue;
            return wb;
        }
        return null;
    }

    private static final class BrowserRenderer
    implements ListCellRenderer<WebBrowser> {
        private final ListCellRenderer<Object> defaultRenderer = new DefaultListCellRenderer();

        private BrowserRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends WebBrowser> list, WebBrowser value, int index, boolean isSelected, boolean cellHasFocus) {
            assert (EventQueue.isDispatchThread());
            Component c = this.defaultRenderer.getListCellRendererComponent(list, BrowserUISupport.getLongDisplayName(value), index, isSelected, cellHasFocus);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setIcon(ImageUtilities.image2Icon((Image)value.getIconImage(true)));
            }
            return c;
        }
    }

    public static final class BrowserComboBoxModel
    extends AbstractListModel<WebBrowser>
    implements ComboBoxModel<WebBrowser> {
        private static final long serialVersionUID = -65798754321321L;
        private final List<WebBrowser> browsers = new CopyOnWriteArrayList<WebBrowser>();
        private volatile WebBrowser selectedBrowser = null;

        BrowserComboBoxModel(List<WebBrowser> browsers) {
            assert (browsers != null);
            assert (!browsers.isEmpty());
            this.browsers.addAll(browsers);
            this.selectedBrowser = browsers.get(0);
        }

        @Override
        public int getSize() {
            return this.browsers.size();
        }

        @Override
        @CheckForNull
        public WebBrowser getElementAt(int index) {
            try {
                return this.browsers.get(index);
            }
            catch (IndexOutOfBoundsException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return null;
            }
        }

        @Override
        public void setSelectedItem(Object browser) {
            this.selectedBrowser = (WebBrowser)browser;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public WebBrowser getSelectedItem() {
            assert (this.selectedBrowser != null);
            return this.selectedBrowser;
        }

        @CheckForNull
        public WebBrowser getSelectedBrowser() {
            assert (this.selectedBrowser != null);
            return this.selectedBrowser;
        }

        public String getSelectedBrowserId() {
            assert (this.selectedBrowser != null);
            return this.selectedBrowser.getId();
        }
    }
}

