/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars.tooltip;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleEval;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleVariableImpl;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private static final Set<String> JS_KEYWORDS = new HashSet<String>(Arrays.asList("break", "case", "catch", "class", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "new", "return", "package", "private", "protected", "public", "static", "super", "switch", "throw", "try", "typeof", "var", "void", "while", "with", "yield"));
    private static final int MAX_TOOLTIP_TEXT = 100000;
    private Line.Part lp;
    private EditorCookie ec;
    private final RequestProcessor RP = new RequestProcessor(ToolTipAnnotation.class);

    public String getShortDescription() {
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (session == null) {
            return null;
        }
        DebuggerEngine engine = session.getCurrentEngine();
        if (engine != session.getEngineForLanguage("GraalVM_Script")) {
            return null;
        }
        JPDADebugger d = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return null;
        }
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp == null) {
            return null;
        }
        Line line = lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        this.lp = lp;
        this.ec = ec;
        this.RP.post((Runnable)this);
        return null;
    }

    public String getAnnotationType() {
        return null;
    }

    @Override
    public void run() {
        String toolTipText;
        StyledDocument doc;
        Object tooltipVariable = null;
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            doc = this.ec.openDocument();
        }
        catch (IOException ex) {
            return;
        }
        JEditorPane ep = EditorContextDispatcher.getDefault().getMostRecentEditor();
        if (ep == null || ep.getDocument() != doc) {
            return;
        }
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (session == null) {
            return;
        }
        DebuggerEngine engine = session.getCurrentEngine();
        if (engine != session.getEngineForLanguage("GraalVM_Script")) {
            return;
        }
        JPDADebugger d = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return;
        }
        JPDAThread thread = d.getCurrentThread();
        if (thread == null || TruffleAccess.getCurrentPCInfo(thread) == null) {
            return;
        }
        boolean[] isFunctionPtr = new boolean[]{false};
        int offset = NbDocument.findLineOffset((StyledDocument)doc, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn();
        String expression = ToolTipAnnotation.getIdentifier(d, doc, ep, offset, isFunctionPtr);
        if (expression == null) {
            return;
        }
        if (isFunctionPtr[0]) {
            // empty if block
        }
        try {
            Variable result = TruffleEval.evaluate(d, expression);
            if (result == null) {
                return;
            }
            TruffleVariableImpl tv = TruffleVariableImpl.get(result);
            String displayVal = tv != null ? tv.getDisplayValue() : result.getValue();
            toolTipText = expression + " = " + displayVal;
        }
        catch (InvalidExpressionException ex) {
            toolTipText = expression + " = >" + ex.getMessage() + "<";
        }
        toolTipText = ToolTipAnnotation.truncateLongText(toolTipText);
        this.firePropertyChange("shortDescription", null, toolTipText);
    }

    private static String getIdentifier(JPDADebugger debugger, StyledDocument doc, JEditorPane ep, int offset, boolean[] isFunctionPtr) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            String ident = t.substring(identStart, identEnd);
            while (identEnd < lineLen && Character.isWhitespace(t.charAt(identEnd))) {
                ++identEnd;
            }
            if (identEnd < lineLen && t.charAt(identEnd) == '(') {
                isFunctionPtr[0] = true;
            }
            return ident;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private static String truncateLongText(String text) {
        if (text.length() > 100000) {
            text = text.substring(0, 100000) + "...";
        }
        return text;
    }
}

