/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.ResourceLimitEvent;
import org.graalvm.polyglot.Source;

public final class ResourceLimits {
    private static final ResourceLimits EMPTY = new ResourceLimits(null);
    final Object impl;

    ResourceLimits(Object impl) {
        this.impl = impl;
    }

    public static Builder newBuilder() {
        return EMPTY.new Builder();
    }

    public final class Builder {
        long statementLimit;
        Predicate<Source> statementLimitSourceFilter;
        Duration timeLimit;
        Duration timeLimitAccuracy;
        Consumer<ResourceLimitEvent> onLimit;

        Builder() {
        }

        public Builder statementLimit(long limit, Predicate<Source> sourceFilter) {
            if (limit < 0L) {
                throw new IllegalArgumentException("The statement limit must not be negative.");
            }
            this.statementLimit = limit;
            this.statementLimitSourceFilter = sourceFilter;
            return this;
        }

        Builder cpuTimeLimit(Duration timeLimit, Duration accuracy) {
            if (timeLimit != null || accuracy != null) {
                if (timeLimit == null || accuracy == null) {
                    throw new IllegalArgumentException("If a timeLimit is specified accuracy must be specified as well.");
                }
                if (timeLimit.isNegative() || timeLimit.isZero()) {
                    throw new IllegalArgumentException("Time limit must not be negative or zero.");
                }
                if (accuracy.isNegative() || accuracy.isZero()) {
                    throw new IllegalArgumentException("Accuracy must not be negative or zero.");
                }
            }
            this.timeLimit = timeLimit;
            this.timeLimitAccuracy = accuracy;
            return this;
        }

        public Builder onLimit(Consumer<ResourceLimitEvent> onLimit) {
            this.onLimit = onLimit;
            return this;
        }

        public ResourceLimits build() {
            return new ResourceLimits(Engine.getImpl().buildLimits(this.statementLimit, this.statementLimitSourceFilter, this.timeLimit, this.timeLimitAccuracy, this.onLimit));
        }
    }
}

